<?php


namespace Topdata\TopdataLinkedOemRemSW6\Subscriber;

use Shopware\Core\Content\Product\SalesChannel\SalesChannelProductEntity;
use Shopware\Core\System\SalesChannel\Entity\SalesChannelEntitySearchResultLoadedEvent;
use Symfony\Component\EventDispatcher\EventDispatcherInterface;
use Symfony\Component\EventDispatcher\EventSubscriberInterface;
use Topdata\TopdataLinkedOemRemSW6\Service\OemRemSavingsService;


/**
 * 11/2023 created
 * 03/2024 infinite recursion fix --> NOTE: it REMOVES this subscriber from the dispatcher after 1st call of eventHandler
 */
class EnrichRemProductWithSavingsSubscriber implements EventSubscriberInterface
{
    const ENTITY_VAR_NAME__SAVINGS_OVER_OEM = 'TopdataLinkedOemRemSW6_savingsOverOem';


    public function __construct(
        private readonly OemRemSavingsService     $savingsService,
        /**
         * used to remove this subscriber from the dispatcher after 1st call of eventHandler onSalesChannelEntitySearchResultLoaded
         * see https://shopwarian.com/preventing-events-from-triggering-again-and-again-and-again/
         */
        private readonly EventDispatcherInterface $dispatcher,
    )
    {
    }


    public static function getSubscribedEvents(): array
    {
        return [
//            ProductListingResultEvent::class             => 'onProductListingResult',
//            ProductSearchResultEvent::class              => 'onProductSearchResult',
//            'sales_channel.product.process.criteria'     => 'onProductCriteria',
            'sales_channel.product.search.result.loaded' => 'onSalesChannelEntitySearchResultLoaded',
        ];
    }


    /**
     * NOTE: this one REMOVES this subscriber from the dispatcher, so no other subscriber in this file will be called afterwards
     */
    public function onSalesChannelEntitySearchResultLoaded(SalesChannelEntitySearchResultLoadedEvent $event)
    {
        // remove this subscriber from the dispatcher to avoid infinitive recursion
        // NOTE: any other subscriber that is added here will be removed by the dispatcher
        $this->dispatcher->removeSubscriber($this);

        $savingsMap = $this->savingsService->getSavingsOverOemMap($event->getResult(), $event->getSalesChannelContext());
        /** @var SalesChannelProductEntity $element */
        foreach ($event->getResult()->getElements() as $product) {
            if (array_key_exists($product->getUniqueIdentifier(), $savingsMap)) {
                $savings = $savingsMap[$product->getUniqueIdentifier()];
                $product->{self::ENTITY_VAR_NAME__SAVINGS_OVER_OEM} = $savings;
            }
        }
    }


}
