<?php


namespace Topdata\TopdataLinkedOemRemSW6\Subscriber;

use Shopware\Core\Content\Product\SalesChannel\SalesChannelProductEntity;
use Shopware\Core\Framework\DataAbstractionLayer\EntityRepository;
use Shopware\Core\Framework\DataAbstractionLayer\Search\Criteria;
use Shopware\Core\Framework\Struct\ArrayEntity;
use Shopware\Core\System\SalesChannel\Entity\SalesChannelEntitySearchResultLoadedEvent;
use Shopware\Core\System\SalesChannel\Entity\SalesChannelRepository;
use Shopware\Storefront\Page\Product\ProductPageLoadedEvent;
use Symfony\Component\EventDispatcher\EventDispatcherInterface;
use Symfony\Component\EventDispatcher\EventSubscriberInterface;
use Topdata\TopdataLinkedOemRemSW6\Service\OemRemSavingsService;


/**
 * 05/2025 created
 */
class CheckForRemAlternativesSubscriber implements EventSubscriberInterface
{

    public function __construct(
        private readonly SalesChannelRepository $productRepository,
        private readonly OemRemSavingsService   $oemRemSavingsService,
    )
    {
    }


    public static function getSubscribedEvents(): array
    {
        return [
            ProductPageLoadedEvent::class => 'onProductPageLoaded',
        ];
    }


    /**
     * 05/2025 created
     */
    public function onProductPageLoaded(ProductPageLoadedEvent $event): void
    {
        $product = $event->getPage()->getProduct();

        // Simplified check: does it have *any* REM alternative with savings?
        // You might need to load product properties first if not already available.
        $criteria = new Criteria([$product->getId()]);
        $criteria->addAssociation('properties.group'); // Ensure properties are loaded for findBestRemAlternatives
        $loadedProduct = $this->productRepository->search($criteria, $event->getSalesChannelContext())->first();

        if ($loadedProduct) {
            $bestRemDTOs = $this->oemRemSavingsService->findBestRemAlternatives($loadedProduct, $event->getSalesChannelContext(), 1);
            if (!empty($bestRemDTOs)) {
                $product->addExtension('topdata_oem_rem_data', new ArrayEntity(['hasAlternatives' => true]));
            } else {
                $product->addExtension('topdata_oem_rem_data', new ArrayEntity(['hasAlternatives' => false]));
            }
        }
    }

    // TODO: Similar for ProductListingResultEvent, iterate $event->getResult()->getElements()
}
