<?php declare(strict_types=1);


namespace Topdata\TopdataLinkedOemRemSW6\Command;

use Symfony\Component\Console\Attribute\AsCommand;
use Symfony\Component\Console\Command\Command;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Output\OutputInterface;
use Topdata\TopdataFoundationSW6\Command\AbstractTopdataCommand;
use Topdata\TopdataLinkedOemRemSW6\Service\OemRemService;

/**
 * 11/2023 created
 */
#[AsCommand(
    name: 'topdata:linked-oem-rem:refresh-links',
    description: 'fills the table topdata_lor_oem_to_rem with links between oem and rem products'
)]
class RefreshLinksCommand extends AbstractTopdataCommand
{
    private OemRemService $oemRemService;

    public function __construct(OemRemService $oemRemService)
    {
        parent::__construct();
        $this->oemRemService = $oemRemService;
    }

    /**
     * ==== MAIN ====
     */
    public function execute(InputInterface $input, OutputInterface $output): int
    {
        $this->oemRemService->setIo($this->cliStyle);
        $this->oemRemService->refreshLinks();
        $this->done();

        return Command::SUCCESS;
    }

}
