<?php

namespace Topdata\TopdataLinkedOemRemSW6\Traits;

/**
 * 06/2023 created.
 */
trait CreateFromDictTrait
{




    /**
     * generic factory method.
     * it ensures that every key from the array is a valid property of this object
     *
     * 06/2023 created
     *
     * @param array $dict
     * @return static
     */
    public static function createFromDict(array $dict): self
    {
        $ret = new static();
        foreach ($dict as $k => $v) {
            if(!property_exists($ret, $k)) {
                throw new \Exception("Property `$k` does not exist in class " . get_class($ret));
            }
            $ret->{$k} = $v;
        }

        return $ret;
    }

    /**
     * 07/2022 created
     *
     * @param array $values assoc array {key: value}
     * @param string[] $allowList list of allowed keys
     * @return static
     */
    public static function createFromArrayWithAllowList(array $values, array $allowList): self
    {
        $ret = new static();
        foreach($allowList as $key) {
            $ret->{$key} = $values[$key];
        }

        return $ret;
    }


    /**
     * generic factory method.
     *
     * 02/2023 created
     *
     * @param array $values
     * @param string[] $denyList list of ignored/denied keys
     * @return static
     */
    public static function createFromArrayWithDenyList(array $values, array $denyList): self
    {
        $ret = new static();
        foreach ($values as $k => $v) {
            if(!in_array($k, $denyList)) {
                $ret->{$k} = $v;
            }
        }

        return $ret;
    }



}
