<?php declare(strict_types=1);

namespace Topdata\TopdataLinkedOemRemSW6\Migration;

use Doctrine\DBAL\Connection;
use Shopware\Core\Framework\Migration\MigrationStep;

class Migration1700505409 extends MigrationStep
{
    public function getCreationTimestamp(): int
    {
        return 1700505409;
    }

    public function update(Connection $connection): void
    {
        $connection->executeStatement('
            CREATE TABLE IF NOT EXISTS `topdata_lor_oem_to_rem` (
              `reference_oem`                  VARCHAR(128)                             NOT NULL COMMENT "just for debug",
              `oem_product_number`             VARCHAR(128)                             NOT NULL COMMENT "just for debug",
              `rem_product_number`             VARCHAR(128)                             NOT NULL COMMENT "just for debug",
              `oem_product_id`                  BINARY(16)                              NOT NULL,
              `rem_product_id`                  BINARY(16)                              NOT NULL,
              `created_at`          DATETIME(3)                             NOT NULL,
              `updated_at`          DATETIME(3)                             NULL,
              `refresh_run_id`                  VARCHAR(128)                             NOT NULL COMMENT "we use for deleting stale entries when refreshing",
               PRIMARY KEY (oem_product_id, rem_product_id)
            ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

            ALTER TABLE topdata_lor_oem_to_rem
              ADD CONSTRAINT `fk.topdata_lor_oem_to_rem.oem_product_id`FOREIGN KEY (`oem_product_id`)
                REFERENCES `product` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

            ALTER TABLE topdata_lor_oem_to_rem
              ADD CONSTRAINT `fk.topdata_lor_oem_to_rem.rem_product_id`FOREIGN KEY (`rem_product_id`)
                REFERENCES `product` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

        ');

    }

    public function updateDestructive(Connection $connection): void
    {
        // implement update destructive
    }
}
