<?php


namespace Topdata\TopdataLinkedOemRemSW6\Subscriber;

use Shopware\Core\Content\Product\Events\ProductListingResultEvent;
use Shopware\Core\Content\Product\Events\ProductSearchResultEvent;
use Shopware\Core\Content\Product\SalesChannel\SalesChannelProductEntity;
use Shopware\Core\System\SalesChannel\Entity\SalesChannelEntitySearchResultLoadedEvent;
use Shopware\Core\System\SalesChannel\Event\SalesChannelProcessCriteriaEvent;
use Symfony\Component\EventDispatcher\EventSubscriberInterface;
use Topdata\TopdataLinkedOemRemSW6\Service\OemRemService;
use Symfony\Component\EventDispatcher\EventDispatcherInterface;



/**
 * 11/2023 created
 * 03/2024 infinite recursion fix
 */
class MyEventSubscriber implements EventSubscriberInterface
{
    const ENTITY_VAR_NAME__SAVINGS_OVER_OEM = 'TopdataLinkedOemRemSW6_savingsOverOem';

    private OemRemService $oemRemService;

    /**
     * used to remove this subscriber from the dispatcher after 1st call of eventHandler onSalesChannelEntitySearchResultLoaded
     * see https://shopwarian.com/preventing-events-from-triggering-again-and-again-and-again/
     */
    private EventDispatcherInterface $dispatcher;


    public function __construct(
        OemRemService $oemRemService,
        EventDispatcherInterface $dispatcher
    )
    {
        $this->oemRemService = $oemRemService;
        $this->dispatcher = $dispatcher;
    }


    public static function getSubscribedEvents(): array
    {
        return [
//            ProductListingResultEvent::class             => 'onProductListingResult',
//            ProductSearchResultEvent::class              => 'onProductSearchResult',
//            'sales_channel.product.process.criteria'     => 'onProductCriteria',
            'sales_channel.product.search.result.loaded' => 'onSalesChannelEntitySearchResultLoaded',
        ];
    }



    public function onSalesChannelEntitySearchResultLoaded(SalesChannelEntitySearchResultLoadedEvent $event)
    {
        // remove this subscriber from the dispatcher to avoid infinitive recursion
        $this->dispatcher->removeSubscriber($this);


        $savingsMap = $this->oemRemService->getSavingsOverOemMap($event->getResult(), $event->getSalesChannelContext());

        /** @var SalesChannelProductEntity $element */
        foreach ($event->getResult()->getElements() as $product) {
            if(array_key_exists($product->getUniqueIdentifier(), $savingsMap)) {
                $savings = $savingsMap[$product->getUniqueIdentifier()];
                $product->{self::ENTITY_VAR_NAME__SAVINGS_OVER_OEM} = $savings;
            }
        }
    }

}
