const e=`{# Template for the demo data import page #} {# Uses Shopware's UI components for consistent styling #} <sw-page class="topdata-demo-data-index"> <template #content> <sw-card-view> {# Main card containing the action buttons #} <sw-card :isLoading="isLoading" :large="true" :title="$t('TopdataDemoDataImporterSW6.mainCardTitle')" > {# button to import demo data #} <sw-button variant="primary" size="large" :disabled="isLoading" @click="importDemoData" > {{ $t('TopdataDemoDataImporterSW6.importButton') }} </sw-button> &nbsp; {# button to delete demo data #} <sw-button variant="primary" size="large" :disabled="isLoading || !hasDemoProducts" @click="removeDemoData" > {{ $t('TopdataDemoDataImporterSW6.removeButton') }} </sw-button> </sw-card> {# Results card showing existing products #} <sw-card v-if="hasDemoProducts && !isLoading" :title="$t('TopdataDemoDataImporterSW6.resultsTitleExisting', { count: totalProducts })" > <sw-data-grid :dataSource="currentProducts" :columns="productColumns" :show-selection="false" :show-actions="false" /> </sw-card> {# Card for when no demo products are found #} <sw-card v-if="!hasDemoProducts && !isLoading"> <p>{{ $t('TopdataDemoDataImporterSW6.noProductsMessage') }}</p> </sw-card> </sw-card-view> </template> </sw-page>`,{Mixin:o}=Shopware;Shopware.Component.register("topdata-demo-data-index",{template:e,inject:["TopdataDemoDataApiService"],mixins:[o.getByName("notification")],data(){return{isLoading:!1,currentProducts:[],totalProducts:0}},created(){this.fetchDemoDataStatus()},computed:{productColumns(){return[{property:"productNumber",label:this.$t("TopdataDemoDataImporterSW6.columnProductNumber"),allowResize:!0},{property:"name",label:this.$t("TopdataDemoDataImporterSW6.columnName"),allowResize:!0},{property:"ean",label:this.$t("TopdataDemoDataImporterSW6.columnEan"),allowResize:!0},{property:"mpn",label:this.$t("TopdataDemoDataImporterSW6.columnMpn"),allowResize:!0}]},hasDemoProducts(){return this.totalProducts>0}},methods:{async fetchDemoDataStatus(){this.isLoading=!0;try{const{count:t,products:a}=await this.TopdataDemoDataApiService.getStatus();this.totalProducts=t,this.currentProducts=a}catch(t){this.createNotificationError({message:this.$t("TopdataDemoDataImporterSW6.statusErrorMessage")}),console.error(t)}finally{this.isLoading=!1}},async importDemoData(){this.isLoading=!0;try{const t=await this.TopdataDemoDataApiService.installDemoData();t&&t.importedProducts&&t.importedProducts.length>0?this.createNotificationSuccess({message:this.$t("TopdataDemoDataImporterSW6.importedMessage",{count:t.importedProducts.length})}):this.createNotificationInfo({message:this.$t("TopdataDemoDataImporterSW6.nothingToImportMessage")})}catch(t){this.createNotificationError({message:this.$t("TopdataDemoDataImporterSW6.importErrorMessage")}),console.error(t)}finally{await this.fetchDemoDataStatus()}},async removeDemoData(){if(confirm(this.$t("TopdataDemoDataImporterSW6.removeConfirmText"))){this.isLoading=!0;try{const t=await this.TopdataDemoDataApiService.removeDemoData();t&&t.deletedCount>0?this.createNotificationSuccess({message:this.$t("TopdataDemoDataImporterSW6.removeSuccessMessage",{count:t.deletedCount})}):this.createNotificationInfo({message:this.$t("TopdataDemoDataImporterSW6.nothingToRemoveMessage")})}catch(t){this.createNotificationError({message:this.$t("TopdataDemoDataImporterSW6.removeErrorMessage")}),console.error(t)}finally{await this.fetchDemoDataStatus()}}},createNotificationSuccess({message:t}){this.createNotification({variant:"success",title:this.$t("global.default.success"),message:t})},createNotificationError({message:t}){this.createNotification({variant:"error",title:this.$t("global.default.error"),message:t})},createNotificationInfo({message:t}){this.createNotification({variant:"info",title:this.$t("global.default.info"),message:t})}}});class r{constructor(){this.client=Shopware.Service().get("TopdataAdminApiClient")}async installDemoData(){const a=await this.client.post("/topdata-demo-data/install-demodata",{});return a.data||a}async getStatus(){const a=await this.client.get("/topdata-demo-data/status");return a.data||a}async removeDemoData(){const a=await this.client.post("/topdata-demo-data/remove-demodata",{});return a.data||a}}Shopware.Module.register("topdata-demo-data",{type:"plugin",name:"Topdata Demo Data",title:"TopdataDemoDataImporterSW6.mainMenuTitle",description:"TopdataDemoDataImporterSW6.descriptionTextModule",color:"#ff3d58",routes:{index:{component:"topdata-demo-data-index",path:"index"}},navigation:[{label:"TopdataDemoDataImporterSW6.mainMenuTitle",color:"#ff3d58",path:"topdata.demo.data.index",icon:"regular-database",position:100,parent:"sw-content"}]});Shopware.Service().register("TopdataDemoDataApiService",()=>new r);
//# sourceMappingURL=topdata-demo-data-importer-s-w6-2BvZvMb-.js.map
