// ---- import pages ----
import './page/topdata-control-center-overview/topdata-control-center-overview';
import './page/topdata-control-center-detail/topdata_control_center_detail'; // Import the detail component

// ---- register module ----
Shopware.Module.register('topdata-control-center', {
    type: 'plugin',
    name: 'TopdataControlCenter',
    title: 'TopdataControlCenterSW6.general.mainMenuTitle',
    description: 'TopdataControlCenterSW6.general.descriptionTextModule',
    color: '#ff3d58',
    icon: 'default-action-settings',

    routes: {
        overview: {
            component: 'topdata-control-center-overview',
            path: 'overview'
        },
        detail: {
            component: 'topdata-control-center-detail',
            path: 'detail/:id', // :id is a parameter that will be available in the route
        }
    },

    navigation: [
        {
            label: 'TopdataControlCenterSW6.general.mainMenuTitle',
            color: '#ff3d58',
            path: 'topdata.control.center.overview',
            icon: 'default-action-settings',
            position: 100,
            parent: 'sw-content',
        },
    ]
});
