/**
 * Fix for "TS2304: Cannot find name Shopware"
 * TODO: check https://developer.shopware.com/docs/guides/plugins/plugins/administration/the-shopware-object.html
 */
declare var Shopware: any;

import TopdataCcPluginApiService from "../service/topdata-cc-plugin-api-service";
import TopdataApiCredentialsService from '../service/topdata-api-credentials.service';

const { Application } = Shopware;

Application.addServiceProvider('TopdataCcPluginApiService', (container) => {
    const initContainer = Application.getContainer('init');
    return new TopdataCcPluginApiService(initContainer.httpClient, container.loginService);
});

Application.addServiceProvider('TopdataApiCredentialsService', (container) => {
    const initContainer = Application.getContainer('init');
    return new TopdataApiCredentialsService(initContainer.httpClient, container.loginService);
});