import template from './TdxTopConfigTreeViewV2.html.twig';
import './TdxTopConfigTreeViewV2.scss';
import '../TdxTopConfigTreeNodeV2/TdxTopConfigTreeNodeV2';


Shopware.Component.register('TdxTopConfigTreeViewV2', {
    template,
    components: {
        TdxTopConfigTreeNodeV2
    },
    props: {
        treeData: {
            type: Object,
            required: true
        },
        rootKey: {
            type: String,
            default: 'Root'
        }
    },
    data() {
        return {
            selectedNode: null
        };
    },
    methods: {
        selectNode(node) {
            this.selectedNode = node;
        },
        formatValue(value) {
            if (typeof value === "object") {
                return JSON.stringify(value, null, 2);
            }
            return value;
        }
    }

});
