/**
 * Fix for "TS2304: Cannot find name Shopware"
 * TODO: check https://developer.shopware.com/docs/guides/plugins/plugins/administration/the-shopware-object.html
 */
declare var Shopware: any;

const ApiService = Shopware.Classes.ApiService;

/**
 * 10/2024 created
 */
class  TopdataCcPluginApiService extends ApiService {

    /**
     * Constructor for TopdataApiCredentialsService.
     * @param {Object} httpClient - The HTTP client for making requests.
     * @param {Object} loginService - The login service for authentication.
     * @param {string} [apiEndpoint='topdata'] - The API endpoint for Topdata.
     */
    constructor(httpClient, loginService, apiEndpoint = 'topdata') {
        super(httpClient, loginService, apiEndpoint);
    }

    fetchPlugins() {
        return this.httpClient.get('/admin/topdata-control-center/registered-plugins');
    }

    fetchPlugin(pluginName: string) {
        return this.httpClient.get(`/admin/topdata-control-center/registered-plugin/${pluginName}`);
    }

}

export default  TopdataCcPluginApiService;
