import template from './TdxTopConfigTreeNodeV2.html.twig';
import './TdxTopConfigTreeNodeV2.scss';


Shopware.Component.register('TdxTopConfigTreeNodeV2', {
    template,
    props: {
        nodeKey: String,
        nodeValue: [Object, Array, String, Number, Boolean]
    },
    data() {
        return {
            isOpen: false
        };
    },
    computed: {
        isObject() {
            return typeof this.nodeValue === "object" && this.nodeValue !== null;
        }
    },
    methods: {
        toggle() {
            if (this.isObject) {
                this.isOpen = !this.isOpen;
            }
        },
        selectNode() {
            this.$emit("select", { key: this.nodeKey, value: this.nodeValue });
        }
    },
    mounted() {
        console.log('--------- TdxTopConfigTreeNodeV2 mounted');
    }
});
