<?php declare(strict_types=1);

namespace Topdata\TopdataControlCenterSW6\Controller\Admin;

use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\Routing\Attribute\Route;
use Topdata\TopdataFoundationSW6\Service\TopConfigRegistry;
use Topdata\TopdataFoundationSW6\Controller\AbstractTopdataApiController;

/**
 * 10/2024 created
 */
#[Route(defaults: ['_routeScope' => ['administration']])]
class PluginOverviewApiController extends AbstractTopdataApiController
{
    public function __construct(
        private readonly TopConfigRegistry $topConfigRegistry
    )
    {
    }


    #[Route(
        path: '/api/admin/topdata-control-center/registered-plugins',
        methods: ['GET']
    )]
    public function getRegisteredPluginsAction(): JsonResponse
    {
        $topConfigs = $this->topConfigRegistry->getRegisteredTopConfigs();

        $payload = [];
        foreach ($topConfigs as $config) {
            $payload[] = [
                'name'        => $config->getPluginName(),
                'configCount' => count($config->getFlatConfig()),
                'mappings'    => array_values($config->getMapping()),
            ];
        }

        return $this->payloadResponse($payload);
    }

    #[Route(
        path: '/api/admin/topdata-control-center/registered-plugin/{pluginName}',
        methods: ['GET']
    )]
    public function getRegisteredPluginDetailsAction(string $pluginName): JsonResponse
    {
        return $this->payloadResponse([
            'flatConfig'   => $this->topConfigRegistry->getTopConfig($pluginName)->getFlatConfig(),
            'nestedConfig' => $this->topConfigRegistry->getTopConfig($pluginName)->getNestedConfig(),
        ]);
    }
}
