# Plugin Registration

## Register Your Plugin using the provided Compiler Pass 
- in the plugin's main class, register the compiler pass in the `build()` method:
```php

    private const MAPPINGS = [
        'productName'                    => 'import.product.name',
        'productDescription'             => 'import.product.description',
        'productBrand'                   => 'import.product.brand',
        'productEan'                     => 'import.product.ean',
        // ...
    ];

    public function build(ContainerBuilder $container): void
    {
        parent::build($container);
        // ---- register the plugin in Topdata Configration Center's TopConfigRegistry
        if(class_exists(TopConfigServiceCompilerPass::class)) {
            $container->addCompilerPass(new TopConfigServiceCompilerPass(__CLASS__, self::MAPPINGS));
        }
    }

```

### Notes
- The build() method is called when the plugin is loaded by Shopware (e.g. when the plugin is installed or the cache is cleared).