# Usage Guide

## Adding as a Dependency
In your plugin's `composer.json`:
```json
{
    "require": {
        "topdata/topdata-control-center-sw6": "^1.0"
    }
}
```

## Plugin Registration
For information about registering your plugin with the TopConfigRegistry, see [Plugin Registration](40-plugin-registration.en.md).

## Configuration Types
The TopConfigRegistry supports the following value types:
- `string`: String values
- `bool`: Boolean values
- `int`: Integer values

## Best Practices
1. Always use dot notation for new configuration keys
2. Keep configuration mappings in a single location
3. Use type-safe getters
4. Document your configuration keys
5. Handle configuration exceptions appropriately

