<?php

namespace Topdata\TopdataControlCenterSW6\Client;

/**
 * 10/2024 created
 */
class TradeguardApiClient
{
    private string $apiKey = 'sk-tg-api01-DEMO';
    private string $baseUrl = 'https://api.tradeguard.biz';

    public function __construct(?string $apiKey = null)
    {
        if ($apiKey) {
            $this->setApiKey($apiKey);
        }
    }


    /**
     * 10/2024 created
     * @throws \InvalidArgumentException if the API key is invalid
     */
    public function setApiKey(string $apiKey): void
    {
        if (!preg_match('/^sk-tg-api01-[a-zA-Z0-9]+$/', $apiKey)) {
            throw new \InvalidArgumentException('Invalid API key');
        }
        $this->apiKey = $apiKey;
    }

    /**
     * 10/2024 created
     */
    public function getEnabledFeatures(): array
    {
        $response = $this->_get('/v1/enabled-features');

        return json_decode($response, true);
    }


    /**
     * It makes a GET request to the given path and returns the (json) response.
     * We use curl to avoid dependencies on other libraries.
     *
     * 10/2024 created
     */
    private function _get(string $path): string
    {
        $url = $this->baseUrl . $path;
        $ch = curl_init($url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_HTTPHEADER, [
            'Authorization: Bearer ' . $this->apiKey,
        ]);
        $response = curl_exec($ch);
        curl_close($ch);

        return $response;
    }


}