import template from './topdata-control-center-overview.html.twig';

const {Component, Application} = Shopware;

Component.register('topdata-control-center-overview', {
    template,
    inject: [
        'TopdataCcPluginApiService'
    ],
    data:   () => ({
        plugins:   null, // fetched from server
        isLoading: true,
    }),

    created() {
        this.loadPlugins();
    },

    methods: {
        loadPlugins() {
            this.isLoading = true;
            return this.TopdataCcPluginApiService.fetchPlugins()
                .then(response => {
                    this.plugins = response.data.payload;
                })
                .finally(() => {
                    this.isLoading = false;
                });
        },

        navigateToDetail(pluginName) {
            this.$router.push({
                name: 'topdata.control.center.detail',
                params: { id: pluginName }
            });
        }
    },

});
