<?php declare(strict_types=1);

namespace Topdata\TopdataControlCenterSW6\Controller\Admin;

use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\Routing\Attribute\Route;
use Topdata\TopdataControlCenterSW6\Controller\AbstractTopdataApiController;
use Topdata\TopdataControlCenterSW6\Service\TopConfigService;

/**
 * 10/2024 created
 */
#[Route(defaults: ['_routeScope' => ['administration']])]
class PluginOverviewApiController extends AbstractTopdataApiController
{
    public function __construct(
        private readonly TopConfigService $topConfigService
    ) {
    }



    #[Route(
        path: '/api/admin/topdata-control-center/registered-plugins',
        methods: ['GET']
    )]
    public function getRegisteredPluginsAction(): JsonResponse
    {
        return $this->payloadResponse($this->topConfigService->getRegisteredPluginsInfo());
    }

    #[Route(
        path: '/api/admin/topdata-control-center/registered-plugin/{pluginName}',
        methods: ['GET']
    )]
    public function getRegisteredPluginDetailsAction(string $pluginName): JsonResponse
    {
        return $this->payloadResponse([
            'flatConfig' => $this->topConfigService->getFlatConfig($pluginName),
        ]);
    }
}
