import template from './topdata-control-center-detail.html.twig';

Shopware.Component.register('topdata-control-center-detail', {
    template,

    inject: [
        'TopdataCcPluginApiService'
    ],

    data() {
        return {
            plugin: null,
            isLoading: true
        };
    },

    computed: {
        pluginId() {
            return this.$route.params.id;
        }
    },

    created() {
        this.loadPlugin();
    },

    methods: {
        loadPlugin() {
            this.isLoading = true;
            return this.TopdataCcPluginApiService.fetchPlugin(this.pluginId)
                .then(response => {
                    this.plugin = response.data.payload;
                })
                .catch(error => {
                    console.error('Error loading plugin:', error);
                    this.createNotificationError({
                        title: 'Error',
                        message: 'Failed to load plugin details'
                    });
                })
                .finally(() => {
                    this.isLoading = false;
                });
        }
    }
});
