<?php declare(strict_types=1);

namespace Topdata\TopdataControlCenterSW6\Controller\Admin;

use Shopware\Core\Framework\Context;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\Routing\Attribute\Route;
use Topdata\TopdataControlCenterSW6\Service\TopConfigService;

/**
 * 10/2024 created
 */
#[Route(defaults: ['_routeScope' => ['administration']])]
class PluginOverviewController extends AbstractAdminController
{
    public function __construct(
        private readonly TopConfigService $topConfigService
    ) {
    }



    #[Route(
        path: '/api/admin/topdata-control-center/registered-plugins',
        methods: ['GET']
    )]
    public function getRegisteredPlugins(Context $context): JsonResponse
    {
        return $this->payloadResponse($this->topConfigService->getRegisteredPluginsInfo());
    }
}
