<?php declare(strict_types=1);


namespace Topdata\TopdataControlCenterSw6\Controller\Admin;

use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\HttpFoundation\Response;


/**
 * 10/2024 created
 */
abstract class AbstractAdminController extends AbstractController
{
    /**
     * 10/2024 created
     *
     * @param mixed $payload
     * @return JsonResponse
     */
    protected function payloadResponse($payload): JsonResponse
    {
        $body = [
            'success' => true,
            'payload' => $payload,
        ];

        return new JsonResponse($body, Response::HTTP_OK);
    }

    /**
     * 10/2024 created
     *
     * @param string|null $message
     * @param mixed $payload
     * @return JsonResponse
     */
    public function successResponse(?string $message = null, $payload = null): JsonResponse
    {
        $body = [
            'success' => true,
            'message' => $message,
            'payload' => $payload,
        ];

        return new JsonResponse($body, Response::HTTP_OK);
    }


    /**
     * 10/2024 created
     *
     * @param string|null $errorMessage
     * @param int $httpCode
     * @param mixed $payload
     * @return JsonResponse
     */
    public function errorResponse(?string $errorMessage = null, int $httpCode, $payload = null): JsonResponse
    {
        $body = [
            'success' => false,
            'message' => $errorMessage,
            'payload' => $payload,
        ];

        return new JsonResponse($body, $httpCode);
    }

}
