---
title: Installation
---
# Installation

## Introduction

In our manual, we show you step by step how to install and set up the plugin. Despite extensive software testing, minor bugs may still occur in different Shopware environments. We handle such bugfixes quickly and efficiently, usually on the same day.

## Support

If you encounter any problems or have questions while setting up your "TopCONNECTOR", please contact us at: shopware@topdata.de.

## Important Notice

Each installation or update of a plugin in your Shopware shop represents a change to the software. Despite all quality assurance measures carried out by us or Shopware, we cannot rule out the possibility that problems may occur during installation or updates in exceptional cases.

Therefore, we generally recommend:
* Testing new plugins or updates of already installed plugins in a suitable test environment first
* Not deploying them directly to the live environment
* Regular backup of your live environment is also strongly recommended

## System Requirements

* Linux-based operating system with Apache 2.2 or 2.4
* Web server with mod_rewrite module and ability to access .htaccess
* PHP 7.2.x / 7.3.x (7.2.20 and 7.3.7 are not compatible)
* MySQL >= 5.7 (except 8.0.20 and 8.0.21)
* Ability to set up cron jobs
* At least 4 GB of free disk space
* Shell access is required to start the import
* Recommended: memory_limit > 512M


## Setting up your "TopCONNECTOR" Step by Step

1. Download "TopCONNECTOR" for free from the Shopware Community Store
2. Please complete the ordering process by adding "TopCONNECTOR" to your cart and completing the checkout process
3. Download "TopCONNECTOR" in the admin area of your Shopware shop under the "Purchases" menu item and then install the plugin under "My Plugins"
4. In the next step, activate your "TopCONNECTOR"
5. Finally, configure your "TopCONNECTOR" according to your preferences


## Webservice Credentials
After installing the plugin, you need to fill in API credentials to connect to TopData Webservice.

Settings - System - Plugins - TopdataConnector menu (... on the right) - Config

TopData provides you with:

- API User-ID
- API Key
- API Salt

### Demo Credentials

If you want to test the plugin with demo credentials, you can use the following:

- API User-ID: 6
- API Key: nTI9kbsniVWT13Ns
- API Salt: oateouq974fpby5t6ldf8glzo85mr9t6aebozrox


