<?php declare(strict_types=1);

namespace Topdata\FreeTopdataCompareProducts\Storefront\Page\PopupCompareProductsWidget;

use Shopware\Core\System\SalesChannel\SalesChannelContext;
use Shopware\Storefront\Page\PageLoadedEvent;
use Symfony\Component\HttpFoundation\Request;

class PopupCompareProductsWidgetLoadedEvent extends PageLoadedEvent
{
    /**
     * @var PopupCompareProductsWidget
     */
    protected PopupCompareProductsWidget $page;

    public function __construct(PopupCompareProductsWidget $page, SalesChannelContext $salesChannelContext, Request $request)
    {
        $this->page = $page;
        parent::__construct($salesChannelContext, $request);
    }

    public function getPage(): PopupCompareProductsWidget
    {
        return $this->page;
    }
}
