<?php declare(strict_types=1);

namespace Topdata\FreeTopdataCompareProducts\Storefront\Page\PopupCompareProductsWidget;

use Shopware\Storefront\Page\Page;
use Shopware\Core\Content\Product\SalesChannel\SalesChannelProductEntity;

class PopupCompareProductsWidget extends Page
{
    const COMPARE_WEIGHT = 'compare_weight';
    const COMPARE_WIDTH = 'compare_width';
    const COMPARE_HEIGHT = 'compare_height';
    const COMPARE_LENGTH = 'compare_length';
    const COMPARE_CUSTOM_PREFIX = 'compare_cuctom_';
    
    public $products = [];
    public $propertyGroups = [];
    public $propertyGroupsDifferent = [];
    public $productArts = [];
    public $compare = [];
    public $group = 0;
    public $isPopup = true;
    public $translator = false;
    public $compareCustomFields = false;
    
    public $temp;
    
    public function getProductParameterByName(SalesChannelProductEntity $product, $name): string
    {
        $name = (string)$name;
        if($name == self::COMPARE_WEIGHT) {
            return $product->getWeight() 
                ? $product->getWeight().' '.$this->translator->trans('topdata-compare-products.measurement.kg') 
                : '&mdash;';
        }
        
        if($name == self::COMPARE_WIDTH) {
            return $product->getWidth() 
                ? $product->getWidth().' '.$this->translator->trans('topdata-compare-products.measurement.mm') 
                : '&mdash;';
        }
        
        if($name == self::COMPARE_HEIGHT) {
            return $product->getHeight() 
                ? $product->getHeight().' '.$this->translator->trans('topdata-compare-products.measurement.mm') 
                : '&mdash;';
        }
        
        if($name == self::COMPARE_LENGTH) {
            return $product->getLength() 
                ? $product->getLength().' '.$this->translator->trans('topdata-compare-products.measurement.mm') 
                : '&mdash;';
        }
        
        if(strpos($name, self::COMPARE_CUSTOM_PREFIX) === 0) {
            $customFieldName = str_replace(self::COMPARE_CUSTOM_PREFIX, '', $name);
            if (isset($product->getCustomFields()[$customFieldName])) {
                return $this->getCustomFieldStringValue($customFieldName, $product->getCustomFields()[$customFieldName]);
            }
            return '&mdash;';
        }
        
        
        $optionValue = [];
        foreach ($product->getSortedProperties()->getElements() as $group) {
            $gname = (string)$group->getId();
            if(isset($group->getTranslated()['name']) && (string)$group->getTranslated()['name'] != '')
                $gname = (string)$group->getTranslated()['name'];
            elseif($group->getName() && (string)$group->getName() != '')
                $gname = (string)$group->getName();  //misa translation

            if($gname == $name) {
                foreach ($group->getOptions()->getElements() as $option) {
                    if(isset($option->getTranslated()['name']) && (string)$option->getTranslated()['name'] != '')
                        $optionValue[] = (string)$option->getTranslated()['name'];
                    elseif($option->getName() && (string)$option->getName() != '')
                        $optionValue[] = (string)$option->getName();
                    else
                        $optionValue[] = '&mdash;';
                }
            }
        }
        
        return count($optionValue) ? implode(', ' , $optionValue) : '&mdash;';
    }
    
    
    public function getGroupName($name)
    {
        $name = (string)$name;
        if($name == self::COMPARE_WEIGHT) {
            return $this->translator->trans('component.product.feature.label.weight');
        }
        
        if($name == self::COMPARE_WIDTH) {
            return $this->translator->trans('component.product.feature.label.width');
        }
        
        if($name == self::COMPARE_HEIGHT) {
            return $this->translator->trans('component.product.feature.label.height');
        }
        
        if($name == self::COMPARE_LENGTH) {
            return $this->translator->trans('component.product.feature.label.length');
        }
        
        if(strpos($name, self::COMPARE_CUSTOM_PREFIX) === 0) {
            return $this->translator->trans('customFields.'.str_replace(self::COMPARE_CUSTOM_PREFIX, '', $name)).':';
        }
        
        return $name.':';
    }
    
    
    public function getCustomFieldStringValue($customFieldName, $value) : string
    {
        $field = false;
        foreach ($this->compareCustomFields as $customField) {
            if($customField->getName() == $customFieldName) {
                $field = $customField;
                break;
            }
        }
        
        if(!$field || !isset($field->getConfig()['customFieldType'])) {
            return '';
        }
        
        $type = $field->getConfig()['customFieldType'];
        
        if($type == 'text' || $type == 'number') {
            return (string)$value;
        }
        
        if($type == 'checkbox' || $type == 'switch') {
            return $value 
                ? $this->translator->trans('topdata-compare-products.customFields.boolTrue')
                : $this->translator->trans('topdata-compare-products.customFields.boolFalse');
        }
        
        if($type == 'date') {
            return date('Y-m-d H:i:s', strtotime($value));
        }
        
        if($type == 'colorpicker') {
            return '<span class="topdata-compare-products-colorpicker" style="background-color:'.$value.';"></span>';
        }
        
        if($type == 'select') {
            $return = [];
            foreach ($field->getConfig()['options'] as $option) {
                if(is_array($value)) {
                    foreach($value as $val) {
                        if($val == $option['value']) {
                            $return[] = array_shift($option['label']);
                            continue;
                        }
                    }
                }
                elseif($value == $option['value']) {
                    $return[] = array_shift($option['label']);
                    break;
                }
            }
            
            return implode(', ', $return);
        }
        
        return '';
        //return print_r($value, true);
    }
}
