import Plugin from 'src/plugin-system/plugin.class';
import HttpClient from 'src/service/http-client.service';
import DomAccess from 'src/helper/dom-access.helper';

export default class CompareProductsLoadStatePlugin extends Plugin {
    init() {
        try {
            const element = document.querySelector('.topdata-compare-products-path');
            const path = DomAccess.getAttribute(element, 'data-pathstate');

            if (path) {
                const httpClient = new HttpClient(window.accessKey, window.contextToken);
                httpClient.get(path, (response) => {
                    response = JSON.parse(response);

                    if (response.productCount) {
                        document.querySelectorAll('.topdata-compare-products-count-total').forEach(el => {
                            el.innerHTML = response.productCount;
                        });

                        // document.querySelector('.topdata-compare-products-path').classList.remove('topdata-compare-products-hidden');
                        //
                        // response.productIds.forEach(productId => {
                        //     const comparingElements = document.querySelectorAll('.topdata-compare-products-product-comparing-' + productId);
                        //     comparingElements.forEach(el => {
                        //         el.classList.remove('topdata-compare-products-hidden');
                        //     });
                        //
                        //     const compareElements = document.querySelectorAll('.topdata-compare-products-product-compare-' + productId);
                        //     compareElements.forEach(el => {
                        //         el.classList.add('topdata-compare-products-hidden');
                        //     });
                        // });
                    } else {
                        // document.querySelector('.topdata-compare-products-path').classList.add('topdata-compare-products-hidden');
                    }
                });
            }
        } catch (e) {
            console.log(e);
        }
    }
}
