<?php declare(strict_types=1);

namespace Topdata\FreeTopdataCompareProducts\Controller;

use Shopware\Core\Framework\Routing\RoutingException;
use Shopware\Storefront\Controller\StorefrontController;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Routing\Annotation\Route;
use Symfony\Component\HttpFoundation\JsonResponse;
use Shopware\Core\System\SalesChannel\SalesChannelContext;
use Topdata\FreeTopdataCompareProducts\Component\Helper;
use Topdata\FreeTopdataCompareProducts\Storefront\Page\PopupCompareProductsWidget\PopupCompareProductsWidgetLoader;
use Shopware\Core\Framework\Uuid\Uuid;

/**
 * 08/2025 created (extracted from CompareController)
 */
#[Route(defaults: ["_routeScope" => ["storefront"]])]
class ComparePageController extends StorefrontController
{
    /**
     * @param PopupCompareProductsWidgetLoader $popupCompareProductsWidgetLoader
     */
    public function __construct(
        private readonly PopupCompareProductsWidgetLoader $popupCompareProductsWidgetLoader
    )
    {
    }

    /**
     * Displays the compare products page - a tabular comparison of all products on the compare list.
     *
     * @throws RoutingException
     */
    #[Route('/topdata-compare-products',
        name: 'frontend.topdata-compare-products.page.index',
        methods: ['GET']
    )]
    public function productsPage(Request $request, SalesChannelContext $salesChannelContext): Response
    {
        $productIds = explode('-', $request->get('ids'));

        // ---- Validate product IDs
        foreach ($productIds as $key => $id) {
            if (Uuid::isValid((string)$id) === false) {
                unset($productIds[$key]);
            }
        }
        if (!count($productIds)) {
            throw RoutingException::missingRequestParameter('ids');
        }

        // ---- Load the products page
        $page = $this->popupCompareProductsWidgetLoader->loadProductsPage($request, $salesChannelContext, $productIds);
        $response = $this->renderStorefront('@FreeTopdataCompareProducts/storefront/page/topdata-compare-products/index.html.twig', ['page' => $page]);

        return $response;
    }

    /**
     * Displays the products that are in the compare list as product boxes.
     *
     * @throws RoutingException
     */
    #[Route('/topdata-compare-products-list',
        name: 'frontend.topdata-compare-products.page.list',
        methods: ['GET']
    )]
    public function productListPage(Request $request, SalesChannelContext $salesChannelContext): Response
    {
        $productIds = explode('-', $request->get('ids'));

        // ---- Validate product IDs
        foreach ($productIds as $key => $id) {
            if (Uuid::isValid((string)$id) === false) {
                unset($productIds[$key]);
            }
        }
        if (!count($productIds)) {
            throw RoutingException::missingRequestParameter('ids');
        }

        // ---- Load the products list page
        $page = $this->popupCompareProductsWidgetLoader->loadProductsListPage($request, $salesChannelContext, $productIds);
        $response = $this->renderStorefront('@FreeTopdataCompareProducts/storefront/page/topdata-compare-products-list/index.html.twig', ['page' => $page]);

        return $response;
    }
}