<?php declare(strict_types=1);

namespace Topdata\FreeTopdataCompareProducts\Component;

use Symfony\Component\HttpFoundation\Request;

class Helper
{    
    const SESSION_PRODUCT_COMPARE = 'topdata-product-compare';
    
    
    public static function getProductCompareIds(Request $request) : array
    {
        $return = [];
        $productCompare = self::getProductCompare($request);
        foreach ($productCompare as $group) {
            foreach ($group['productIds'] as $productId) {
                if(in_array($productId, $return)) {
                    continue;
                }
                $return[] = $productId;
            }
        }
        
        return $return;
    }
    
    
    public static function getProductCompare(Request $request) : array
    {
        return $request->getSession()->get(self::SESSION_PRODUCT_COMPARE, []);
    }
    
    
    public static function setProductCompare(array &$productComapre, Request $request, string $firstGroupName = '') : void
    {
        usort($productComapre, function($a, $b) {
            return $a['productArt'] <=> $b['productArt'];
        });
        
        if($firstGroupName) {
            foreach ($productComapre as $key  => $group) {
                if($group['productArt'] === $firstGroupName) {
                    $firstGroup = $group;
                    unset($productComapre[$key]);
                    array_unshift($productComapre, $firstGroup);
                    break;
                }
            }
        }
        
        $request->getSession()->set(self::SESSION_PRODUCT_COMPARE, $productComapre);
    }
    
    
    public static function getCompareProductsTotalCount(Request $request) : int
    {
//        $return = 0;
//        $productCompare = self::getProductCompare($request);
//        foreach ($productCompare as $group) {
//            $return += count($group['productIds']);
//        }
//        
//        return $return;
        return count(self::getProductCompareIds($request));
    }
    
    public static function isValidUuid($uuid) : bool
    {
        if(!is_string($uuid)) {
            return false;
        }
        return (bool)preg_match('/^[0-9a-f]{32}$/', $uuid);
    }
    
}