# Configuration Guide

This guide explains all the configuration options for the "Topdata Compare Products" plugin. You can find these settings in your Shopware Admin under `Extensions > My Extensions > Topdata Compare Products > Configuration`.

## Product Grouping

This section controls how products are grouped for comparison.

*   **Show compare button**:
    *   When enabled, a compare icon is displayed on product boxes in listings and on the product detail page.
    *   If you have the "Topdata Product Menu" plugin installed, a compare option will also be added to that menu.

*   **Allow compare products without special property**:
    *   If you define a "Property to group products" (see below), this setting determines the behavior for products that *do not* have that specific property.
    *   **Enabled (Default)**: Products without the grouping property can still be added to a default comparison group.
    *   **Disabled**: Only products that possess the selected grouping property can be compared.

*   **Maximum number of products in the comparison group**:
    *   Sets the maximum number of products that can be compared against each other within a single group (e.g., in one tab of the compare modal). Default is 4.

*   **Maximum number of comparison groups**:
    *   Sets the maximum number of different comparison groups (tabs) that can be active at the same time. Default is 4.
    *   This is relevant if a "Property to group products" is selected, as products with different values for that property will create separate groups.

*   **Property to group products**:
    *   Allows you to select a product property (e.g., "Device Type") to be used for grouping.
    *   When a user adds a product, they will be added to a comparison group based on their value for this property (e.g., all "Smartphones" in one group, all "Tablets" in another).
    *   If no property is selected, all products are added to one universal comparison group.

*   **Hidden properties**:
    *   Allows you to select one or more property groups that should be hidden from the comparison table. This is useful for excluding irrelevant or technical properties.

## Compare Extra Fields

This section allows you to include non-property fields in the comparison table.

*   **Show product number**: When enabled, the product number is displayed for each item in the comparison.
*   **Show EAN**: When enabled, the EAN is displayed for each item.
*   **Show manufacturer product number**: When enabled, the Manufacturer Product Number (MPN) is displayed for each item.
*   **Compare weight**: When enabled, product weight is included as a comparable attribute.
*   **Compare width**: When enabled, product width is included as a comparable attribute.
*   **Compare height**: When enabled, product height is included as a comparable attribute.
*   **Compare length**: When enabled, product length is included as a comparable attribute.
*   **Compare by custom fields**:
    *   Select custom fields to be included in the comparison table.
    *   **Supported field types**: `text`, `number`, `date/time`, `checkbox`, `active switch`, `colour picker`, and `select`. Other types will be ignored.

---

[Next: Usage Guide](./usage.md)
