# Usage Guide

This guide explains how customers can use the product comparison feature on your storefront.

## Adding Products to Compare

1.  A customer can add a product to the comparison list by clicking the compare icon (`<sw_icon 'chart-bar-filled'>`). This icon appears on product boxes in category listings and on the product detail page.
2.  After clicking the icon, a small modal window confirms that the product has been added.
3.  The total number of products being compared will appear in the shop's header.

## The Comparison Modal

Customers can view the comparison list by clicking on the "Compare products" link in the header. This opens a full-screen modal with the following features:

*   **Products Display**: Compared products are shown side-by-side in columns, displaying their image, title, price, and an "add to cart" button.
*   **Property Table**: Below the products, a table lists all relevant properties.
    *   **Different Values**: Properties where the products have different values are highlighted with an icon (`<sw_icon 'x'>`).
    *   **Same Values**: Properties where all products share the same value are marked with an icon (`<sw_icon 'checkmark'>`).
*   **Group Tabs**: If product grouping is active in the plugin configuration, customers will see tabs at the top of the modal. They can switch between different comparison groups (e.g., "Smartphones" and "Tablets").
*   **Removing a Product**: Each product in the comparison has a remove (`<sw_icon 'x'>`) button to take it off the list.

## Filtering and Viewing Options

Within the modal, several controls are available:

*   **Show Properties Differences / All**: A button that allows the user to toggle between viewing all properties and viewing only the properties that have different values among the products.
*   **Hide/Show Properties**: A button to collapse or expand the entire properties table.
*   **Show on Page**: This button opens a new, shareable page that displays the current comparison. This is useful for sending a direct link to someone.
*   **Share Link**: On mobile devices, a "Share Comparison" button appears, allowing users to easily share the URL of the comparison page.

---

[Back to: Introduction](./index.md)
