---
title: Verwendungsanleitung
---

# Verwendungsanleitung

Diese Anleitung erklärt, wie Sie die Farbanzeigefunktionalität in Ihrem Shopware-Shop einrichten und verwenden.

## Einrichtung von Produkteigenschaften

### Schritt 1: Eigenschaftsgruppen erstellen

1. Navigieren Sie zu **Kataloge > Eigenschaften** in Ihrer Shopware Administration
2. Klicken Sie auf **Eigenschaftsgruppe hinzufügen**
3. Geben Sie einen Namen für Ihre Farb-Eigenschaftsgruppe ein (z.B. "Produktfarben", "Hauptfarbe", "Akzentfarbe")
4. Konfigurieren Sie die Gruppeneinstellungen:
   - **Anzeigetyp**: Wählen Sie, wie Eigenschaften in Filtern angezeigt werden sollen
   - **Sortierungstyp**: Legen Sie fest, wie Farboptionen sortiert werden sollen
   - **Filterbar**: Aktivieren Sie dies, wenn Kunden nach Farben filtern können sollen

### Schritt 2: Farbeigenschaften hinzufügen

1. Öffnen Sie Ihre neu erstellte Eigenschaftsgruppe
2. Klicken Sie auf **Eigenschaft hinzufügen**, um einzelne Farboptionen hinzuzufügen
3. Für jede Farbeigenschaft:
   - **Name**: Geben Sie den Farbnamen ein (z.B. "Rot", "Blau", "Waldgrün")
   - **Farb-Hex-Code**: Setzen Sie optional einen spezifischen Hex-Code (dies überschreibt die integrierten Farben des Plugins)
   - **Position**: Legen Sie die Anzeigereihenfolge fest
   - **Medien**: Fügen Sie optional ein Farbmuster-Bild hinzu

### Schritt 3: Plugin-Einstellungen konfigurieren

1. Gehen Sie zu **Erweiterungen > Meine Erweiterungen > Topdata Colors > Konfigurieren**
2. Wählen Sie im Feld **Farben Eigenschaften** die von Ihnen erstellten Eigenschaftsgruppen aus
3. Konfigurieren Sie andere Einstellungen nach Bedarf (siehe Konfigurationseinstellungen-Anleitung)
4. Speichern Sie die Konfiguration

### Schritt 4: Eigenschaften zu Produkten zuweisen

1. Bearbeiten Sie ein Produkt unter **Kataloge > Produkte**
2. Gehen Sie zum Tab **Eigenschaften**
3. Wählen Sie die entsprechenden Farbeigenschaften für dieses Produkt aus
4. Speichern Sie das Produkt

## Verstehen der Farbanzeige-Logik

### Prioritäten der Farbzuordnung

Das Plugin ermittelt die Farbe für eine Eigenschaft anhand einer klaren Prioritätenreihenfolge. Sobald eine passende Farbe gefunden wird, werden die nachfolgenden Schritte ignoriert:

1.  **Property ID-Überschreibungen (Höchste Priorität)**
    - Zuerst prüft das Plugin auf Zuordnungen, die gezielt eine Property-ID ansprechen (z. B. `01992d6707037fd4bdb44e0d743ce6e0|#ff00ff`). Wenn eine passende Property-ID-Zuordnung vorhanden ist, wird diese verwendet.
    - **Beispiel**: `01992d6707037fd4bdb44e0d743ce6e0|#FF00FF` erzwingt für die Property mit der ID `01992d6707037fd4bdb44e0d743ce6e0` die Darstellung in Pink, unabhängig vom Property-Namen oder anderen Einstellungen.

2.  **Benutzerdefinierte Farbüberschreibungen**
    - Als Nächstes prüft das Plugin, ob der Name der Eigenschaft in der Plugin-Konfiguration unter "Eigene/überschriebene Farben" definiert ist.
    - **Beispiel**: Wenn Sie `rot|#FF00FF` definieren, wird "Rot" angezeigt, sofern keine ID-Überschreibung vorhanden ist.

3.  **Eigenschafts-Hex-Code**
    - Wenn keine benutzerdefinierte Überschreibung oder ID-Zuordnung gefunden wurde, prüft das Plugin, ob für die Eigenschaft selbst ein "Farb-Hex-Code" in der Shopware-Administration (unter **Kataloge > Eigenschaften**) hinterlegt ist.
    - **Beispiel**: Hat die Eigenschaft "Rot" den Hex-Code `#FFC0CB`, wird dieser Wert verwendet.

4.  **Integrierte Farbdatenbank (Niedrigste Priorität)**
    - Wenn keine der oben genannten Bedingungen erfüllt sind, durchsucht das Plugin die integrierte Datenbank mit über 200 vordefinierten Farben.
    - **Beispiel**: Ist die Eigenschaft "Rot" nicht überschrieben, wird der Standardwert `#ff0000` verwendet.

### Farbnamen-Zuordnung

Farbnamen werden case-insensitiv zugeordnet. Diese funktionieren alle gleich:
- "Rot" → entspricht der integrierten roten Farbe
- "rot" → entspricht der integrierten roten Farbe  
- "ROT" → entspricht der integrierten roten Farbe

### Mehrfarben-Syntax

Das Plugin unterstützt erweiterte Farbkombinationen:

#### Anzahl-Präfixe
- `3x rot` → Zeigt 3 rote Punkte an
- `2x blau` → Zeigt 2 blaue Punkte an

#### Farbkombinationen
- `rot+blau` → Zeigt rote und blaue Punkte zusammen an (primärer Trenner)
- `rot/blau` → Legacy-Trenner (weiterhin aus Gründen der Abwärtskompatibilität unterstützt)
- `rot+blau+grün` → Zeigt drei Farben zusammen an

#### Komplexe Beispiele
- `2x rot+blau` → Zeigt 2 Kombinationspunkte an (jeweils mit rot und blau)
- `3x mehrfarbig` → Zeigt 3 mehrfarbige Punkte an
- `rot, blau, grün` → Zeigt separate Farbgruppen an (kommagetrennt)

## Produkteinrichtungsbeispiele

### Beispiel 1: Einfaches einfarbiges Produkt

**Produkt**: Rotes T-Shirt
**Eigenschaftszuweisung**: "Rot" aus der Gruppe "Produktfarben"
**Ergebnis**: Einzelner roter Punkt wird angezeigt

### Beispiel 2: Mehrfarbiges Produkt

**Produkt**: Gestreiftes Hemd
**Eigenschaftszuweisung**: "Rot+Blau" aus der Gruppe "Produktfarben"
**Ergebnis**: Rote und blaue Punkte werden zusammen angezeigt

### Beispiel 3: Produkt mit mehreren Farboptionen

**Produkt**: In mehreren Farben verfügbar
**Eigenschaftszuweisung**: "Rot", "Blau", "Grün" aus der Gruppe "Produktfarben"
**Ergebnis**: Drei separate Farbpunkte werden angezeigt

### Beispiel 4: Produkt mit Farbvariationen

**Produkt**: Jacke mit Akzentfarben
**Eigenschaftszuweisung**: 
- "Schwarz" aus der Gruppe "Hauptfarbe"
- "Rot" aus der Gruppe "Akzentfarbe"
**Ergebnis**: Schwarzer Punkt und roter Punkt werden angezeigt

## Best Practices

### Eigenschaftsbenennung

1. **Verwenden Sie Standardfarbnamen** wenn möglich (rot, blau, grün, etc.)
2. **Seien Sie konsistent** in Ihrem Produktkatalog
3. **Verwenden Sie beschreibende Namen** für benutzerdefinierte Farben (z.B. "Waldgrün" statt "Grün1")
4. **Berücksichtigen Sie Übersetzungen** wenn Sie in mehreren Sprachen operieren

### Organisation von Eigenschaftsgruppen

1. **Erstellen Sie spezifische Gruppen** für verschiedene Farbtypen:
   - "Hauptfarbe" für primäre Produktfarben
   - "Akzentfarbe" für sekundäre Farben
   - "Musterfarben" für mehrfarbige Muster

2. **Halten Sie Gruppen fokussiert** - mischen Sie Farbeigenschaften nicht mit anderen Attributen
3. **Verwenden Sie klare Benennung**, die für Ihr Team sinnvoll ist

### Farbüberschreibungsstrategie

1. **Beginnen Sie mit integrierten Farben** bevor Sie benutzerdefinierte Überschreibungen hinzufügen
2. **Dokumentieren Sie benutzerdefinierte Farben** für Ihr Team
3. **Verwenden Sie Hex-Codes konsistent** (#ff0000 Format)
4. **Testen Sie Farbkombinationen** bevor Sie live gehen

## Anzeigeorte

Farben erscheinen automatisch in:

### Produktlistenseiten
- Kategorienseiten
- Suchergebnisse
- Markenseiten
- Tag-Seiten

### Produktdetailseiten
- Hauptproduktinformationsbereich
- Variantenauswahl (falls zutreffend)

### Cross-Selling-Bereiche
- Verwandte Produkte
- Empfohlene Produkte
- Kürzlich angesehene Produkte

### Vergleichsfunktionen
- Produktvergleichs-Popups
- Wunschlistenanzeigen

## Fehlerbehebung häufiger Probleme

### Farben erscheinen nicht

1. **Überprüfen Sie die Eigenschaftsgruppenauswahl** in der Plugin-Konfiguration
2. **Überprüfen Sie die Eigenschaftszuweisung** zu Produkten
3. **Leeren Sie den Cache** nach Konfigurationsänderungen
4. **Überprüfen Sie die Farbnamen-Schreibweise** gegen die integrierte Datenbank

### Falsche Farben werden angezeigt

1. **Überprüfen Sie Eigenschaftsnamen** gegen Farbdatenbankeinträge
2. **Überprüfen Sie benutzerdefinierte Farbüberschreibungen** auf Konflikte
3. **Überprüfen Sie Eigenschafts-Hex-Codes** in der Eigenschaftskonfiguration
4. **Testen Sie mit einfachen Farbnamen** zuerst

### Performance-Optimierung

1. **Begrenzen Sie Eigenschaftsgruppen** auf nur die für Farben benötigten
2. **Verwenden Sie einfache Farbnamen** statt komplexer Überschreibungen wenn möglich
3. **Vermeiden Sie übermäßige benutzerdefinierte SVG-Komplexität**
4. **Überwachen Sie Seitenladezeiten** bei vielen Farbeigenschaften

## Erweiterte Verwendung

### Benutzerdefinierte Farbdefinitionen

Für Farben, die nicht in der integrierten Datenbank enthalten sind, fügen Sie sie zu den Farbüberschreibungen hinzu:

```
firmen-blau|#1e3a8a
marken-rot|#dc2626
benutzerdefiniert-grün|#059669
```

### Muster- und Verlaufsfarben

Erstellen Sie spezielle visuelle Effekte:

```
regenbogen|linear-gradient(45deg, #ff0000, #00ff00, #0000ff)
streifen|repeating-linear-gradient(45deg, #000, #000 2px, #fff 2px, #fff 4px)
```

### Mehrsprachige Unterstützung

Definieren Sie Farbnamen in mehreren Sprachen:

```
rot|#ff0000
rouge|#ff0000
rojo|#ff0000
```

## Integration mit Themes

Das Plugin funktioniert mit den meisten Shopware-Themes. Falls Sie das Erscheinungsbild anpassen müssen:

1. **Überschreiben Sie Templates** in Ihrem Theme falls nötig
2. **Fügen Sie benutzerdefiniertes CSS** hinzu, um Farbanzeigen zu stylen
3. **Verwenden Sie bereitgestellte CSS-Klassen** für das Styling:
   - `.topdata-color` - Hauptcontainer
   - `.color` - Einzelne Farbelemente
   - `.group` - Farbgruppen-Container

## Testen Ihrer Einrichtung

1. **Erstellen Sie Testprodukte** mit verschiedenen Farbkombinationen
2. **Überprüfen Sie verschiedene Seitentypen** (Listing, Detail, Suche)
3. **Testen Sie mit verschiedenen Geräten** und Bildschirmgrößen
4. **Überprüfen Sie die Farbgenauigkeit** entspricht Ihren Erwartungen
5. **Testen Sie die Performance** mit realistischen Produktkatalogen

Durch das Befolgen dieser Anleitung sollten Sie in der Lage sein, die Farbanzeigefunktionalität erfolgreich in Ihrem Shopware-Shop zu implementieren und zu verwenden.
