---
title: Configuration Settings
---

# Configuration Settings

Access the plugin configuration through **Extensions > My Extensions > Topdata Colors > Configure** in your Shopware Administration.

## Configuration Options

### 1. Color Style

**Field Name**: `colorStyle`  
**Type**: Single Select  
**Default Value**: `drop`

Choose the visual style for displaying color indicators:

- **Drop**: Teardrop-shaped color indicators
- **Point**: Circular color dots
- **Quad**: Square-shaped color indicators  
- **Italic Quad**: Tilted square-shaped color indicators

Each style uses a predefined SVG shape that will be filled with the appropriate color. The selected style applies to all color displays throughout your store.

### 2. Custom SVG

**Field Name**: `ownSvg`  
**Type**: Textarea  
**Default Value**: Empty

Upload your own custom SVG code for color display. When this field contains SVG code, the "Color Style" selection above will be ignored.

**Important Notes**:
- The color will be applied via the CSS `fill` property
- Your SVG should be designed to work with dynamic fill colors
- A CSS class `own-svg` will be automatically applied to custom SVG elements
- Ensure your SVG is properly formatted and valid

**Example SVG Structure**:
```xml
<?xml version="1.0" encoding="utf-8"?>
<svg version="1.2" baseProfile="tiny" xmlns="http://www.w3.org/2000/svg" 
     viewBox="0 0 1280 1280" xml:space="preserve">
    <path d="M6094.9,12800L6094.9,12800L40,0h12760"/>
</svg>
```

### 3. Color Overrides

**Field Name**: `colorOverwrite`
**Type**: Textarea
**Default Value**: Empty

Define custom color mappings or override existing color definitions.

**Important Note**: This setting has the **highest priority**. A color defined here will override both the hex code set on a property and the plugin's built-in color database.

Property ID overrides:
- You can assign a specific color to an individual property by using the property ID as the key, e.g. `01992d6707037fd4bdb44e0d743ce6e0|#ff00ff`. This forces the color for that exact property regardless of property name or other matching rules.
- This ID-based mapping takes precedence over name-matching, but is still superseded by entries in `colorOverwrite` if a matching override exists there.

This allows you to:
- Add new color names not in the built-in database
- Override existing color definitions with different hex codes
- Create multi-color combinations

### 4. Color Property Groups

**Field Name**: `colorPropertyGroups`  
**Type**: Multi-Select Entity Selector  
**Entity**: Property Groups  
**Default Value**: Empty

Select which property groups should be used for color display. Only properties from the selected groups will be processed for color visualization.

**Setup Process**:
1. First, create property groups in **Catalogues > Properties**
2. Add color-related properties to these groups (e.g., "Color", "Farbe", "Main Color")
3. Select the appropriate property groups in this configuration field
4. Assign these properties to your products

**Best Practices**:
- Create dedicated property groups specifically for colors
- Use clear, descriptive names for color properties
- Consider creating separate groups for different color types (main color, accent color, etc.)
- Ensure property names match the built-in color database or your custom overrides

## Built-in Color Database

The plugin includes an extensive database of over 200 color names with corresponding hex codes, supporting both English and German color names:

**Examples of Supported Colors**:
- Basic colors: `red`, `blue`, `green`, `yellow`, `black`, `white`
- German colors: `rot`, `blau`, `grün`, `gelb`, `schwarz`, `weiß`
- Extended colors: `aquamarine`, `cornflowerblue`, `darkslategray`
- Special combinations: `multicolor`, `transparent`, `3-farbig`

## Advanced Configuration Tips

### Multi-Color Products
The plugin supports complex color combinations using special syntax:
- **Count Prefix**: `3x red` displays three red dots
- **Color Combinations**: `red+blue` (primary) or `red/blue` (legacy) for multi-color items
- **Mixed Syntax**: `2x red+blue` for two red-blue combination dots

### CSS Customization
You can further customize the appearance using CSS:
- Target `.topdata-color` for the main container
- Use `.color` for individual color elements
- Apply styles to specific shape classes: `.drop`, `.circle`, `.quad`, `.cursivequad`, `.own-svg`

### Performance Considerations
- Limit the number of selected property groups to improve performance
- Use the built-in color database when possible instead of extensive custom overrides
- Consider caching implications when using complex CSS gradients or patterns
