<?php

namespace Topdata\TopdataColors\Twig;

use http\Encoding\Stream\Debrotli;
use Topdata\TopdataColors\Service\ColorService;
use Shopware\Core\Content\Product\SalesChannel\SalesChannelProductEntity;
use Twig\Extension\AbstractExtension;
use Twig\TwigFunction;
use Shopware\Core\System\SystemConfig\SystemConfigService;


/**
 * 05/2024 created
 */
class MyTwigExtension extends AbstractExtension
{
    public function __construct(
        private readonly ColorService        $colorService,
        private readonly SystemConfigService $systemConfigService,
    )
    {
    }

    public function getFunctions(): array
    {
        return [
            new TwigFunction('TopdataColorsSW6_getColorValuesAndExistingColorCodes', [$this, 'getColorValuesAndExistingColorCodes']),
            new TwigFunction('TopdataColorsSW6_getSvgCode', [$this, 'getSvgCode']),
            // new TwigFunction('TopdataColorsSW6_getMapColorNameToCssColor', [$this, 'getMapColorNameToCssColor']),
        ];
    }


    /**
     * Get SVG code for color display.
     */
    public function getSvgCode(): string
    {
        if (!empty(trim($this->systemConfigService->get('TopdataColors.config.ownSvg')))) {
            return $this->systemConfigService->get('TopdataColors.config.ownSvg');
        } else {
            $pathSvgFile = __DIR__ . '/../Resources/svg-icons/' . $this->systemConfigService->get('TopdataColors.config.colorStyle') . '.svg';
            return file_get_contents($pathSvgFile);
        }

    }

//    public function getMapColorNameToCssColor(array $overwrites): array
//    {
//        return $this->colorService->getMapColorNameToCssColor($overwrites);
//    }

    public function getColorValuesAndExistingColorCodes(SalesChannelProductEntity $product): array
    {
        return $this->colorService->getColorValuesAndExistingColorCodes($product);
    }
}