---
title: Konfigurationseinstellungen
---

# Konfigurationseinstellungen

Greifen Sie auf die Plugin-Konfiguration über **Erweiterungen > Meine Erweiterungen > Topdata Colors > Konfigurieren** in Ihrer Shopware Administration zu.

## Konfigurationsoptionen

### 1. Farben Darstellung

**Feldname**: `colorStyle`  
**Typ**: Einfachauswahl  
**Standardwert**: `drop`

Wählen Sie den visuellen Stil für die Anzeige von Farbindikatoren:

- **Tropfen**: Tropfenförmige Farbindikatoren
- **Punkt**: Kreisförmige Farbpunkte
- **Quadrat**: Quadratische Farbindikatoren  
- **Kursiv Quadrat**: Geneigte quadratische Farbindikatoren

Jeder Stil verwendet eine vordefinierte SVG-Form, die mit der entsprechenden Farbe gefüllt wird. Der ausgewählte Stil gilt für alle Farbanzeigen in Ihrem Shop.

### 2. Eigenes Farben SVG

**Feldname**: `ownSvg`  
**Typ**: Textbereich  
**Standardwert**: Leer

Laden Sie Ihren eigenen benutzerdefinierten SVG-Code für die Farbanzeige hoch. Wenn dieses Feld SVG-Code enthält, wird die Auswahl "Farben Darstellung" oben ignoriert.

**Wichtige Hinweise**:
- Die Farbe wird über die CSS-Eigenschaft `fill` angewendet
- Ihr SVG sollte für die Verwendung mit dynamischen Füllfarben konzipiert sein
- Eine CSS-Klasse `own-svg` wird automatisch auf benutzerdefinierte SVG-Elemente angewendet
- Stellen Sie sicher, dass Ihr SVG ordnungsgemäß formatiert und gültig ist

**Beispiel SVG-Struktur**:
```xml
<?xml version="1.0" encoding="utf-8"?>
<svg version="1.2" baseProfile="tiny" xmlns="http://www.w3.org/2000/svg" 
     viewBox="0 0 1280 1280" xml:space="preserve">
    <path d="M6094.9,12800L6094.9,12800L40,0h12760"/>
</svg>
```

### 3. Eigene/überschriebene Farben

**Feldname**: `colorOverwrite`
**Typ**: Textbereich
**Standardwert**: Leer

Definieren Sie benutzerdefinierte Farbzuordnungen oder überschreiben Sie bestehende Farbdefinitionen.

**Wichtiger Hinweis**: Diese Einstellung hat die **höchste Priorität**. Eine hier definierte Farbe überschreibt sowohl den in einer Eigenschaft gesetzten Hex-Code als auch die integrierte Farbdatenbank des Plugins.

Dies ermöglicht es Ihnen:
- Neue Farbnamen hinzuzufügen, die nicht in der integrierten Datenbank enthalten sind
- Bestehende Farbdefinitionen mit anderen Hex-Codes zu überschreiben
- Mehrfarbige Kombinationen zu erstellen

**Erweiterte Farbdefinitionen**:
- **Einzelfarbe**: `rot|#ff0000`
- **Mehrfarbig**: `regenbogen|#ff0000/#00ff00/#0000ff`
- **CSS-Verläufe**: `verlauf|linear-gradient(45deg, #ff0000, #0000ff)`
- **Muster-Überschreibungen**: `streifen|repeating-linear-gradient(45deg, #000, #000 2px, #fff 2px, #fff 4px)`

### 4. Farben Eigenschaften

**Feldname**: `colorPropertyGroups`  
**Typ**: Mehrfachauswahl Entity-Selektor  
**Entity**: Eigenschaftsgruppen  
**Standardwert**: Leer

Wählen Sie aus, welche Eigenschaftsgruppen für die Farbanzeige verwendet werden sollen. Nur Eigenschaften aus den ausgewählten Gruppen werden für die Farbvisualisierung verarbeitet.

**Einrichtungsprozess**:
1. Erstellen Sie zunächst Eigenschaftsgruppen unter **Kataloge > Eigenschaften**
2. Fügen Sie farbbezogene Eigenschaften zu diesen Gruppen hinzu (z.B. "Farbe", "Color", "Hauptfarbe")
3. Wählen Sie die entsprechenden Eigenschaftsgruppen in diesem Konfigurationsfeld aus
4. Weisen Sie diese Eigenschaften Ihren Produkten zu

**Best Practices**:
- Erstellen Sie dedizierte Eigenschaftsgruppen speziell für Farben
- Verwenden Sie klare, beschreibende Namen für Farbeigenschaften
- Erwägen Sie separate Gruppen für verschiedene Farbtypen (Hauptfarbe, Akzentfarbe, etc.)
- Stellen Sie sicher, dass Eigenschaftsnamen mit der integrierten Farbdatenbank oder Ihren benutzerdefinierten Überschreibungen übereinstimmen

## Integrierte Farbdatenbank

Das Plugin enthält eine umfangreiche Datenbank mit über 200 Farbnamen und entsprechenden Hex-Codes, die sowohl englische als auch deutsche Farbnamen unterstützt:

**Beispiele unterstützter Farben**:
- Grundfarben: `red`, `blue`, `green`, `yellow`, `black`, `white`
- Deutsche Farben: `rot`, `blau`, `grün`, `gelb`, `schwarz`, `weiß`
- Erweiterte Farben: `aquamarine`, `kornblumenblau`, `dunkelschiefergrau`
- Spezielle Kombinationen: `multicolor`, `transparent`, `3-farbig`

## Erweiterte Konfigurationstipps

### Mehrfarbige Produkte
Das Plugin unterstützt komplexe Farbkombinationen mit spezieller Syntax:
- **Anzahl-Präfix**: `3x rot` zeigt drei rote Punkte an
- **Farbkombinationen**: `rot+blau` (primär) oder `rot/blau` (legacy) für mehrfarbige Artikel
- **Gemischte Syntax**: `2x rot+blau` für zwei rot-blaue Kombinationspunkte

### CSS-Anpassung
Sie können das Erscheinungsbild mit CSS weiter anpassen:
- Zielen Sie auf `.topdata-color` für den Hauptcontainer
- Verwenden Sie `.color` für einzelne Farbelemente
- Wenden Sie Stile auf spezifische Form-Klassen an: `.drop`, `.circle`, `.quad`, `.cursivequad`, `.own-svg`

### Performance-Überlegungen
- Begrenzen Sie die Anzahl der ausgewählten Eigenschaftsgruppen zur Verbesserung der Performance
- Verwenden Sie die integrierte Farbdatenbank wenn möglich, anstatt umfangreiche benutzerdefinierte Überschreibungen
- Berücksichtigen Sie Cache-Auswirkungen bei der Verwendung komplexer CSS-Verläufe oder Muster
