<?php

namespace Topdata\TopdataColors\Twig;


use Shopware\Core\Content\Product\SalesChannel\SalesChannelProductEntity;
use Shopware\Core\System\SystemConfig\SystemConfigService;
use Twig\Extension\AbstractExtension;
use Twig\TwigFunction;


/**
 * 05/2024 created
 */
class MyTwigExtension extends AbstractExtension
{


    private SystemConfigService $systemConfigService;

    public function __construct(SystemConfigService $systemConfigService)
    {
        $this->systemConfigService = $systemConfigService;
    }


    public function getFunctions(): array
    {
        return [
            new TwigFunction('TopdataColorsSW6_getColorValuesAndExistingColorCodes', [$this, 'TopdataColorsSW6_getColorValuesAndExistingColorCodes']),
            new TwigFunction('TopdataColorsSW6_getSvgCode', [$this, 'TopdataColorsSW6_getSvgCode']),
            new TwigFunction('TopdataColorsSW6_getMapColorNameToCssColor', [$this, 'TopdataColorsSW6_getMapColorNameToCssColor']),
        ];
    }

    /**
     * 05/2024 created
     */
    public function TopdataColorsSW6_getSvgCode(): string
    {
        if (!empty(trim($this->systemConfigService->get('TopdataColors.config.ownSvg')))) {
            return $this->systemConfigService->get('TopdataColors.config.ownSvg');
        } else {
            $pathSvgFile = __DIR__ . '/../Resources/svg-icons/' . $this->systemConfigService->get('TopdataColors.config.colorStyle') . '.svg';
            return file_get_contents($pathSvgFile);
        }

    }


    public function TopdataColorsSW6_getMapColorNameToCssColor(array $overwrites): array
    {
//    {# color codes of plugin configuration will use to overwrite #}
//    {% if config('TopdataColors.config.colorOverwrite') is not empty %}
//        {% set owColors = config('TopdataColors.config.colorOverwrite')|trim|split('\n') %}
//        {% for owColor in owColors %}
//            {% set owColor = owColor|trim|split('|') %}
//            {% if owColor|length == 2 %}
//                {% set mapColorNameToCssColor = mapColorNameToCssColor|merge({(owColor[0]|trim): owColor[1]|trim|split('/')}) %}
//            {% endif %}
//        {% endfor %}
//    {% endif %}

        // ---- default map
        $map = self::_getDefaultMapColorNameToCssColor();

        // ---- overwrites 1
        if(!empty($overwrites)) {
            $map = array_merge($map, $overwrites);
        }

        // ---- overwrites 2
        $colorOverwrite = $this->systemConfigService->get('TopdataColors.config.colorOverwrite');
        if (!empty($colorOverwrite)) {
            $owColors = explode("\n", $colorOverwrite);
            foreach ($owColors as $owColor) {
                $owColor = explode('|', trim($owColor));
                if (count($owColor) == 2) {
                    $map[strtolower($owColor[0])] = explode('/', trim($owColor[1]));
                }
            }
        }

        return $map;

    }


    /**
     * extracted from colors.html.twig
     * TODO: move somewhere else (a service?, json?)
     * TODO: remove duplicates
     * 05/2024 created
     */
    private static function _getDefaultMapColorNameToCssColor(): array
    {
        return [
            'transparent'             => '#fff linear-gradient(45deg,rgba(0,0,0,.15) 25%,transparent 25%,transparent 50%,rgba(0,0,0,.15) 50%,rgba(0,0,0,.15) 75%,transparent 75%,transparent)',
            'eisfarben'               => '#f0f8ff',
            'anthrazit'               => '#494D53',
            'antikweiß'               => '#faebd7',
            'wasser'                  => '#00ffff',
            'aquamarinblau'           => '#7fffd4',
            'himmelblau'              => '#f0ffff',
            'beige'                   => '#f5f5dc',
            'biskuit'                 => '#ffe4c4',
            'schwarz matt'            => '#000000',
            'schwarz'                 => '#000000',
            'photo schwarz'           => '#000000',
            'titan'                   => '#868686',
            'mandelweiß'              => '#ffebcd',
            'blau'                    => '#0000ff',
            'blauviolett'             => '#8a2be2',
            'braun'                   => '#a52a2a',
            'gelbbraun'               => '#deb887',
            'kadettenblau'            => '#5f9ea0',
            'hellgrün'                => '#7fff00',
            'schokolade'              => '#d2691e',
            'koralle'                 => '#ff7f50',
            'kornblumenblau'          => '#6495ed',
            'mais'                    => '#fff8dc',
            'karmesinrot'             => '#dc143c',
            'türkis'                  => '#00ffff',
            'dunkelblau'              => '#00008b',
            'dunkeltürkis'            => '#008b8b',
            'dunkle goldrutenfarbe'   => '#b8860b',
            'dunkelgrün'              => '#006400',
            'dunkelgrau'              => '#a9a9a9',
            'dunkelkhaki'             => '#bdb76b',
            'dunkelmagenta'           => '#8b008b',
            'dunkles olivgrün'        => '#556b2f',
            'dunkles orange'          => '#ff8c00',
            'dunkle orchidee'         => '#9932cc',
            'dunkelrot'               => '#8b0000',
            'dunkle lachsfarbe'       => '#e9967a',
            'dunkles seegrün'         => '#8fbc8f',
            'dunkles schieferblau'    => '#483d8b',
            'dunkles schiefergrau'    => '#2f4f4f',
            'dunkeltürkis'            => '#00ced1',
            'dunkelvilolett'          => '#9400d3',
            'tiefrosa'                => '#ff1493',
            'mehrfarbig'              => 'linear-gradient(45deg, red , yellow, blue)',
            'tiefes himmelblau'       => '#00bfff',
            'dunkelgrau'              => '#696969',
            'persenningblau'          => '#1e90ff',
            'backstein'               => '#b22222',
            'blütenweiß'              => '#fffaf0',
            'waldgrün'                => '#228b22',
            'fuchsia'                 => '#ff00ff',
            'gainsboro'               => '#dcdcdc',
            'geisterweiß'             => '#f8f8ff',
            'gold'                    => '#ffd700',
            'goldrute'                => '#daa520',
            'grau'                    => '#808080',
            'grün'                    => '#008000',
            'grüngelb'                => '#adff2f',
            'grau'                    => '#808080',
            'rauchgrau'               => '#808080',
            'honigmelone'             => '#f0fff0',
            'leuchtendes rosa'        => '#ff69b4',
            'indischrot'              => '#cd5c5c',
            'indigo'                  => '#4b0082',
            'elfenbein'               => '#fffff0',
            'staubfarben'             => '#f0e68c',
            'lavendel'                => '#e6e6fa',
            'graphit'                 => '#45484D',
            'lavendelrosa'            => '#fff0f5',
            'rasengrün'               => '#7cfc00',
            'chiffongelb'             => '#fffacd',
            'hellblau'                => '#add8e6',
            'helles korallenrot'      => '#f08080',
            'helles cyan'             => '#e0ffff',
            'helles magenta'          => '#FFCCFF',
            'helles goldrutengelb'    => '#fafad2',
            'hellgrau'                => '#d3d3d3',
            'hellgrün'                => '#90ee90',
            'hellgrau'                => '#d3d3d3',
            'hellrosa'                => '#ffb6c1',
            'helle lachsfarbe'        => '#ffa07a',
            'helles seegrün'          => '#20b2aa',
            'helles himmelblau'       => '#87cefa',
            'helles schiefergrau'     => '#778899',
            'helles stahlblau'        => '#b0c4de',
            'hellgelb'                => '#ffffe0',
            'limone'                  => '#00ff00',
            'limonengrün'             => '#32cd32',
            'leinen'                  => '#faf0e6',
            'magenta'                 => '#ff00ff',
            'kastanie'                => '#800000',
            'mittleres aquamarin'     => '#66cdaa',
            'mittleres blau'          => '#0000cd',
            'mittlere orchidee'       => '#ba55d3',
            'mittleres violett'       => '#9370db',
            'mittleres seegrün'       => '#3cb371',
            'mittleres schieferblau'  => '#7b68ee',
            'mittleres frühlingsgrün' => '#00fa9a',
            'mittlere türkis'         => '#48d1cc',
            'mittleres violettrot'    => '#c71585',
            'mitternachtsblau'        => '#191970',
            'cremige minze'           => '#f5fffa',
            'altrosa'                 => '#ffe4e1',
            'mokassin'                => '#ffe4b5',
            'navajoweiß'              => '#ffdead',
            'marinenblau'             => '#000080',
            'alte spitze'             => '#fdf5e6',
            'olivgrün'                => '#808000',
            'olivgraubraun'           => '#6b8e23',
            'orange'                  => '#ffa500',
            'orangerot'               => '#ff4500',
            'orchidee'                => '#da70d6',
            'blasse goldrutenfarbe'   => '#eee8aa',
            'blassgrün'               => '#98fb98',
            'blasstürkis'             => '#afeeee',
            'blasses violettrot'      => '#db7093',
            'papayacreme'             => '#ffefd5',
            'pfirsich'                => '#ffdab9',
            'peru'                    => '#cd853f',
            'rosa'                    => '#ffc0cb',
            'pflaume'                 => '#dda0dd',
            'taubenblau'              => '#b0e0e6',
            'violett'                 => '#800080',
            'rot'                     => '#ff0000',
            'rosiges braun'           => '#bc8f8f',
            'königsbalu'              => '#4169e1',
            'sattelbraun'             => '#8b4513',
            'lachsfarben'             => '#fa8072',
            'sandbraun'               => '#f4a460',
            'seegrün'                 => '#2e8b57',
            'muschel'                 => '#fff5ee',
            'siennaerde'              => '#a0522d',
            'silber'                  => '#c0c0c0',
            'himmelblau'              => '#87ceeb',
            'schieferblau'            => '#6a5acd',
            'schiefergrau'            => '#708090',
            'schneeweiß'              => '#fffafa',
            'frühlingsgrün'           => '#00ff7f',
            'stahlblau'               => '#4682b4',
            'hautfarben'              => '#d2b48c',
            'krickentengrün'          => '#008080',
            'distel'                  => '#d8bfd8',
            'tomate'                  => '#ff6347',
            'türkis'                  => '#40e0d0',
            'veilchen'                => '#ee82ee',
            'weizen'                  => '#f5deb3',
            'weiß'                    => '#ffffff',
            'rauchfarben'             => '#f5f5f5',
            'gelb'                    => '#ffff00',
            'gelbgrün'                => '#9acd32',
            'aliceblue'               => '#f0f8ff',
            'antiquewhite'            => '#faebd7',
            'aqua'                    => '#00ffff',
            'aquamarine'              => '#7fffd4',
            'azure'                   => '#f0ffff',
            'beige'                   => '#f5f5dc',
            'bisque'                  => '#ffe4c4',
            'black foto'              => '#000000',
            'black'                   => '#000000',
            'blanchedal- mond'        => '#ffebcd',
            'blue'                    => '#0000ff',
            'blueviolet'              => '#8a2be2',
            'brown'                   => '#a52a2a',
            'burlywood'               => '#deb887',
            'cadetblue'               => '#5f9ea0',
            'chartreuse'              => '#7fff00',
            'chocolate'               => '#d2691e',
            'coral'                   => '#ff7f50',
            'cornflowerblue'          => '#6495ed',
            'cornsilk'                => '#fff8dc',
            'crimson'                 => '#dc143c',
            'cyan'                    => '#00ffff',
            'darkblue'                => '#00008b',
            'darkcyan'                => '#008b8b',
            'darkgoldenrod'           => '#b8860b',
            'darkgreen'               => '#006400',
            'darkgrey'                => '#a9a9a9',
            'darkkhaki'               => '#bdb76b',
            'darkmagenta'             => '#8b008b',
            'darkolivegreen'          => '#556b2f',
            'darkorange'              => '#ff8c00',
            'darkorchid'              => '#9932cc',
            'darkred'                 => '#8b0000',
            'darksalmon'              => '#e9967a',
            'darkseagreen'            => '#8fbc8f',
            'darkslateblue'           => '#483d8b',
            'dark slateyellow'        => '#2f4f4f',
            'darkturquoise'           => '#00ced1',
            'darkviolet'              => '#9400d3',
            'deeppink'                => '#ff1493',
            'deepskyblue'             => '#00bfff',
            'dimgrey'                 => '#696969',
            'dodgerblue'              => '#1e90ff',
            'firebrick'               => '#b22222',
            'floralwhite'             => '#fffaf0',
            'forestgreen'             => '#228b22',
            'fuchsia'                 => '#ff00ff',
            'gainsboro'               => '#dcdcdc',
            'ghostwhite'              => '#f8f8ff',
            'gold'                    => '#ffd700',
            'goldenrod'               => '#daa520',
            'gray'                    => '#808080',
            'green'                   => '#008000',
            'greenyellow'             => '#adff2f',
            'grey'                    => '#808080',
            'honeydew'                => '#f0fff0',
            'hotpink'                 => '#ff69b4',
            'indianred'               => '#cd5c5c',
            'indigo'                  => '#4b0082',
            'ivory'                   => '#fffff0',
            'khaki'                   => '#f0e68c',
            'lavender'                => '#e6e6fa',
            'lavenderblush'           => '#fff0f5',
            'lawngreen'               => '#7cfc00',
            'lemonchiffon'            => '#fffacd',
            'lightblue'               => '#add8e6',
            'lightcoral'              => '#f08080',
            'lightcyan'               => '#e0ffff',
            'light cyan'              => '#e0ffff',
            'cyan light'              => '#e0ffff',
            'magenta light'           => '#FFCCFF',
            'lightmagenta'            => '#FFCCFF',
            'light magenta'           => '#FFCCFF',
            'light goldenrod yellow'  => '#fafad2',
            'lightgray'               => '#d3d3d3',
            'lightgreen'              => '#90ee90',
            'lightgrey'               => '#d3d3d3',
            'lightpink'               => '#ffb6c1',
            'lightsalmon'             => '#ffa07a',
            'lightseagreen'           => '#20b2aa',
            'lightskyblue'            => '#87cefa',
            'lightslategrey'          => '#778899',
            'lightsteelblue'          => '#b0c4de',
            'lightyellow'             => '#ffffe0',
            'yellow light'            => '#ffffe0',
            'lime'                    => '#00ff00',
            'limegreen'               => '#32cd32',
            'linen'                   => '#faf0e6',
            'magenta'                 => '#ff00ff',
            'maroon'                  => '#800000',
            'medium aquamarine'       => '#66cdaa',
            'medium blue'             => '#0000cd',
            'medium orchid'           => '#ba55d3',
            'medium purple'           => '#9370db',
            'medium seagreen'         => '#3cb371',
            'medium slateblue'        => '#7b68ee',
            'medium springgreen'      => '#00fa9a',
            'medium turquoise'        => '#48d1cc',
            'medium violetred'        => '#c71585',
            'midnightblue'            => '#191970',
            'mintcream'               => '#f5fffa',
            'mistyrose'               => '#ffe4e1',
            'moccasin'                => '#ffe4b5',
            'navajowhite'             => '#ffdead',
            'navy'                    => '#000080',
            'oldlace'                 => '#fdf5e6',
            'olive'                   => '#808000',
            'olivedrab'               => '#6b8e23',
            'orange'                  => '#ffa500',
            'orangered'               => '#ff4500',
            'orchid'                  => '#da70d6',
            'palegoldenrod'           => '#eee8aa',
            'palegreen'               => '#98fb98',
            'paleturquoise'           => '#afeeee',
            'palevioletred'           => '#db7093',
            'papayawhip'              => '#ffefd5',
            'peachpuff'               => '#ffdab9',
            'peru'                    => '#cd853f',
            'pink'                    => '#ffc0cb',
            'plum'                    => '#dda0dd',
            'powderblue'              => '#b0e0e6',
            'purple'                  => '#800080',
            'lila'                    => '#800080',
            'red'                     => '#ff0000',
            'rosybrown'               => '#bc8f8f',
            'royalblue'               => '#4169e1',
            'saddlebrown'             => '#8b4513',
            'salmon'                  => '#fa8072',
            'sandybrown'              => '#f4a460',
            'seagreen'                => '#2e8b57',
            'seashell'                => '#fff5ee',
            'sienna'                  => '#a0522d',
            'silver'                  => '#c0c0c0',
            'skyblue'                 => '#87ceeb',
            'slateblue'               => '#6a5acd',
            'slategrey'               => '#708090',
            'snow'                    => '#fffafa',
            'springgreen'             => '#00ff7f',
            'steelblue'               => '#4682b4',
            'tan'                     => '#d2b48c',
            'teal'                    => '#008080',
            'thistle'                 => '#d8bfd8',
            'tomato'                  => '#ff6347',
            'turquoise'               => '#40e0d0',
            'violet'                  => '#ee82ee',
            'wheat'                   => '#f5deb3',
            'white'                   => '#ffffff',
            'whitesmoke'              => '#f5f5f5',
            'yellow'                  => '#ffff00',
            'yellowgreen'             => '#9acd32',
            '3-farbig'                => ['#00ffff', '#ff00ff', '#ffff00'],
            'rgb'                     => ['#00ffff', '#ff00ff', '#ffff00'],
            'farbig'                  => ['#00ffff', '#ff00ff', '#ffff00'],
            'cmy'                     => ['#e0ffff', '#ff00ff', '#ffff00'],
            'cmyk'                    => ['#e0ffff', '#ff00ff', '#000000'],
            '4-farbig'                => ['#00ffff', '#ff00ff', '#ffff00', '#000000'],
            '5-farbig'                => ['#00ffff', '#ff00ff', '#ffff00', '#e0ffff', '#FFCCFF'],
            'color'                   => ['#00ffff', '#ff00ff', '#ffff00'],
            'weiss'                   => '#ffffff',
            'chamois'                 => '#efe0b9',
            'lichtgrau'               => '#c4caca',
            'türkisblau'              => '#21888f',
            'bordeaux'                => '#8D273C',
            'xenon'                   => '#14397f'
        ];


    }

    /**
     * 05/2024 created (extracted from twig template)
     */
    public function TopdataColorsSW6_getColorValuesAndExistingColorCodes(SalesChannelProductEntity $product): array
    {
//        {% set colorValues = [] %}
//        {% set existingColorCodes = [] %}
//        {% for groupId in config('TopdataColors.config.colorPropertyGroups') %}
//            {% for element in product.properties.elements %}
//                {% if element.groupId == groupId %}
//                    {% if element.translated['name'] %}
//                        {% set colorValues = colorValues|merge([element.translated['name']]) %}
//                    {% elseif element.name %}
//                        {% set colorValues = colorValues|merge([element.name]) %}
//                    {% endif %}
//                    {% if element.colorHexCode is not empty %}
//                        {% set existingColorCodes = existingColorCodes|merge({(element.name): element.colorHexCode}) %}
//                    {% endif %}
//                {% endif %}
//            {% endfor %}
//        {% endfor %}

        $colorPropertyGroups = $this->systemConfigService->get('TopdataColors.config.colorPropertyGroups');
        if (empty($colorPropertyGroups)) {
            return [
                'colorValues'        => [],
                'existingColorCodes' => []
            ];
        }

        // ---- main
        $colorValues = [];
        $existingColorCodes = [];
        $productProperties = $product->getProperties();

        // ---- workaround for $productProperties === null (for the case when the product has no properties (?))
        // or maybe an event subscriber is needed to add Association to Criteria?
        if(empty($productProperties)) {
            return [
                'colorValues'        => [],
                'existingColorCodes' => []
            ];
        }


        foreach ($colorPropertyGroups as $groupId) {
            foreach ($productProperties as $element) {
                if ($element->getGroupId() == $groupId) {
                    // -- color value
                    if ($element->getTranslated()['name']) {
                        $colorValues = array_merge($colorValues, [$element->getTranslated()['name']]);
                    } elseif ($element->getName()) {
                        $colorValues = array_merge($colorValues, [$element->getName()]);
                    }
                    // -- color code from the property.. it overwrites the "default color" from the plugin
                    if ($element->getColorHexCode()) {
                        $existingColorCodes[strtolower($element->getName())] = $element->getColorHexCode();
                    }
                }
            }
        }

//        return [
//            'colorValues'        => ['blau', 'black', '3x rot', '3x lila, braun', '4x schwarz+grün', '2x xenon', 'farbig/cmyk', 'multicolor', 'strips'],
//            'existingColorCodes' => ['black' => '#ff7700']
//        ];
        return [
            'colorValues'        => $colorValues,
            'existingColorCodes' => $existingColorCodes,
        ];

    }

}