---
title: Frequently Asked Questions
---

# Frequently Asked Questions

## General Questions

### Q: What is the purpose of this plugin?
**A:** Topdata Colors SW6 displays visual color indicators (dots, shapes) on product listings and detail pages based on product properties. This helps customers quickly identify product colors without having to read text descriptions.

### Q: Which Shopware versions are supported?
**A:** The plugin supports Shopware 6.6.* and 6.7.* versions.

### Q: Does the plugin work with custom themes?
**A:** Yes, the plugin integrates with Shopware's template system and should work with most custom themes. The color displays are added through template extensions that respect your theme's styling.

## Setup and Configuration

### Q: Why don't I see any color dots on my products?
**A:** Check the following:
1. Ensure you've selected property groups in the plugin configuration
2. Verify that your products have properties assigned from those groups
3. Make sure the property names match colors in the built-in database or your custom overrides
4. Clear the cache after configuration changes

### Q: How do I add a new color that's not in the built-in database?
**A:** Use the "Color Overrides" field in the plugin configuration:
```
mynewcolor|#ff5733
```
Each color definition should be on a separate line, with the color name and hex code separated by a pipe symbol (`|`).

### Q: Can I use custom color names in different languages?
**A:** Yes, you can define custom color names in any language using the color overrides feature:
```
rouge|#ff0000
azul|#0000ff
```

### Q: How do I create multi-colored indicators?
**A:** Use forward slashes to separate multiple colors:
```
rainbow|#ff0000/#00ff00/#0000ff
```
This will create multiple color dots for a single property.

## Property Setup

### Q: How do I set up property groups for colors?
**A:** 
1. Go to **Catalogues > Properties** in Shopware Administration
2. Create a new property group (e.g., "Colors")
3. Add individual color properties to this group (e.g., "Red", "Blue", "Green")
4. In the plugin configuration, select this property group
5. Assign these properties to your products

### Q: Can I use multiple property groups for colors?
**A:** Yes, you can select multiple property groups in the plugin configuration. The plugin will process properties from all selected groups.

### Q: What happens if a product has multiple color properties?
**A:** All color properties from the selected groups will be displayed. Each property creates its own color indicator.

## Advanced Features

### Q: How does the count syntax work (e.g., "3x red")?
**A:** The plugin recognizes count prefixes:
- `3x red` displays three red dots
- `2x blue+white` displays two blue-white combination dots
- The format is `[number]x [color]`

### Q: Can I use CSS gradients or patterns?
**A:** Yes, you can use any valid CSS color value in the color overrides:
```
gradient|linear-gradient(45deg, #ff0000, #0000ff)
stripes|repeating-linear-gradient(45deg, #000, #000 2px, #fff 2px, #fff 4px)
```

### Q: How do I use custom SVG shapes?
**A:** Paste your SVG code into the "Custom SVG" field in the plugin configuration. The SVG should be designed to work with the CSS `fill` property for coloring.

## Troubleshooting

### Q: Colors are not displaying correctly
**A:** Check the following:
1. Verify that property names exactly match color names in the database or overrides
2. Ensure color codes are valid hex values (e.g., `#ff0000`)
3. Clear browser cache and Shopware cache
4. Check browser console for JavaScript errors

### Q: Plugin configuration is not saving
**A:** 
1. Check file permissions on the Shopware installation
2. Verify database connectivity
3. Look for error messages in the Shopware logs
4. Ensure you have proper admin permissions

### Q: Colors appear but with wrong colors
**A:** This usually indicates a mismatch between property names and color definitions:
1. Check the exact spelling of your property names
2. Verify color names are lowercase in overrides
3. Ensure hex codes are properly formatted with `#` prefix

### Q: Performance issues with many products
**A:** 
1. Limit the number of selected property groups
2. Avoid complex CSS gradients for large product catalogs
3. Consider using simple hex colors instead of gradients
4. Ensure proper caching is enabled

## Integration Questions

### Q: Does this work with product variants?
**A:** Yes, the plugin works with product variants. Each variant can have its own color properties and will display accordingly.

### Q: Can I customize the CSS styling?
**A:** Yes, you can add custom CSS to modify the appearance:
- `.topdata-color` - Main container
- `.color` - Individual color elements
- `.drop`, `.circle`, `.quad`, `.cursivequad`, `.own-svg` - Shape-specific classes

### Q: Does this affect search functionality?
**A:** No, the plugin only adds visual elements and doesn't modify Shopware's search functionality.

### Q: Can I disable colors for specific products?
**A:** Simply don't assign color properties to products where you don't want color displays to appear.

## Migration and Updates

### Q: What happens to my configuration when updating the plugin?
**A:** Your configuration settings are preserved during plugin updates. However, always backup your configuration before updating.

### Q: Can I export/import color configurations?
**A:** Currently, there's no built-in export/import feature. You can manually copy the configuration values from the plugin settings.

### Q: How do I migrate from an older version?
**A:** Follow the standard Shopware plugin update process. Check the changelog for any breaking changes or required migration steps.

## Support

### Q: Where can I get additional support?
**A:** Contact TopData Software GmbH through their website at [https://www.topdata.de](https://www.topdata.de) for technical support and additional resources.

### Q: How do I report bugs or request features?
**A:** Contact the plugin developer through the official support channels provided by TopData Software GmbH.
