---
title: Häufig gestellte Fragen
---

# Häufig gestellte Fragen

## Allgemeine Fragen

### F: Was ist der Zweck dieses Plugins?
**A:** Topdata Colors SW6 zeigt visuelle Farbindikatoren (Punkte, Formen) auf Produktlisten und Detailseiten basierend auf Produkteigenschaften an. Dies hilft Kunden, Produktfarben schnell zu identifizieren, ohne Textbeschreibungen lesen zu müssen.

### F: Welche Shopware-Versionen werden unterstützt?
**A:** Das Plugin unterstützt Shopware 6.6.* und 6.7.* Versionen.

### F: Funktioniert das Plugin mit benutzerdefinierten Themes?
**A:** Ja, das Plugin integriert sich in Shopwares Template-System und sollte mit den meisten benutzerdefinierten Themes funktionieren. Die Farbanzeigen werden über Template-Erweiterungen hinzugefügt, die das Styling Ihres Themes respektieren.

## Einrichtung und Konfiguration

### F: Warum sehe ich keine Farbpunkte bei meinen Produkten?
**A:** Überprüfen Sie folgende Punkte:
1. Stellen Sie sicher, dass Sie Eigenschaftsgruppen in der Plugin-Konfiguration ausgewählt haben
2. Überprüfen Sie, dass Ihre Produkte Eigenschaften aus diesen Gruppen zugewiesen haben
3. Stellen Sie sicher, dass die Eigenschaftsnamen mit Farben in der integrierten Datenbank oder Ihren benutzerdefinierten Überschreibungen übereinstimmen
4. Leeren Sie den Cache nach Konfigurationsänderungen

### F: Wie füge ich eine neue Farbe hinzu, die nicht in der integrierten Datenbank enthalten ist?
**A:** Verwenden Sie das Feld "Eigene/überschriebene Farben" in der Plugin-Konfiguration:
```
meineneufarbe|#ff5733
```
Jede Farbdefinition sollte in einer separaten Zeile stehen, wobei Farbname und Hex-Code durch ein Pipe-Symbol (`|`) getrennt sind.

### F: Kann ich benutzerdefinierte Farbnamen in verschiedenen Sprachen verwenden?
**A:** Ja, Sie können benutzerdefinierte Farbnamen in jeder Sprache mit der Farbüberschreibungsfunktion definieren:
```
rouge|#ff0000
azul|#0000ff
```

### F: Wie erstelle ich mehrfarbige Indikatoren?
**A:** Verwenden Sie Schrägstriche, um mehrere Farben zu trennen:
```
regenbogen|#ff0000/#00ff00/#0000ff
```
Dies erstellt mehrere Farbpunkte für eine einzelne Eigenschaft.

## Eigenschaftseinrichtung

### F: Wie richte ich Eigenschaftsgruppen für Farben ein?
**A:** 
1. Gehen Sie zu **Kataloge > Eigenschaften** in der Shopware Administration
2. Erstellen Sie eine neue Eigenschaftsgruppe (z.B. "Farben")
3. Fügen Sie einzelne Farbeigenschaften zu dieser Gruppe hinzu (z.B. "Rot", "Blau", "Grün")
4. Wählen Sie in der Plugin-Konfiguration diese Eigenschaftsgruppe aus
5. Weisen Sie diese Eigenschaften Ihren Produkten zu

### F: Kann ich mehrere Eigenschaftsgruppen für Farben verwenden?
**A:** Ja, Sie können mehrere Eigenschaftsgruppen in der Plugin-Konfiguration auswählen. Das Plugin verarbeitet Eigenschaften aus allen ausgewählten Gruppen.

### F: Was passiert, wenn ein Produkt mehrere Farbeigenschaften hat?
**A:** Alle Farbeigenschaften aus den ausgewählten Gruppen werden angezeigt. Jede Eigenschaft erstellt ihren eigenen Farbindikator.

## Erweiterte Funktionen

### F: Wie funktioniert die Anzahl-Syntax (z.B. "3x rot")?
**A:** Das Plugin erkennt Anzahl-Präfixe:
- `3x rot` zeigt drei rote Punkte an
- `2x blau+weiß` zeigt zwei blau-weiße Kombinationspunkte an
- Das Format ist `[Zahl]x [Farbe]`

### F: Kann ich CSS-Verläufe oder Muster verwenden?
**A:** Ja, Sie können jeden gültigen CSS-Farbwert in den Farbüberschreibungen verwenden:
```
verlauf|linear-gradient(45deg, #ff0000, #0000ff)
streifen|repeating-linear-gradient(45deg, #000, #000 2px, #fff 2px, #fff 4px)
```

### F: Wie verwende ich benutzerdefinierte SVG-Formen?
**A:** Fügen Sie Ihren SVG-Code in das Feld "Eigenes Farben SVG" in der Plugin-Konfiguration ein. Das SVG sollte für die Verwendung mit der CSS-Eigenschaft `fill` für die Farbgebung konzipiert sein.

## Fehlerbehebung

### F: Farben werden nicht korrekt angezeigt
**A:** Überprüfen Sie folgende Punkte:
1. Überprüfen Sie, dass Eigenschaftsnamen exakt mit Farbnamen in der Datenbank oder Überschreibungen übereinstimmen
2. Stellen Sie sicher, dass Farbcodes gültige Hex-Werte sind (z.B. `#ff0000`)
3. Leeren Sie Browser-Cache und Shopware-Cache
4. Überprüfen Sie die Browser-Konsole auf JavaScript-Fehler

### F: Plugin-Konfiguration wird nicht gespeichert
**A:** 
1. Überprüfen Sie Dateiberechtigungen der Shopware-Installation
2. Überprüfen Sie die Datenbankverbindung
3. Suchen Sie nach Fehlermeldungen in den Shopware-Logs
4. Stellen Sie sicher, dass Sie über ordnungsgemäße Admin-Berechtigungen verfügen

### F: Farben erscheinen, aber mit falschen Farben
**A:** Dies deutet normalerweise auf eine Nichtübereinstimmung zwischen Eigenschaftsnamen und Farbdefinitionen hin:
1. Überprüfen Sie die exakte Schreibweise Ihrer Eigenschaftsnamen
2. Überprüfen Sie, dass Farbnamen in Überschreibungen kleingeschrieben sind
3. Stellen Sie sicher, dass Hex-Codes ordnungsgemäß mit `#`-Präfix formatiert sind

### F: Performance-Probleme bei vielen Produkten
**A:** 
1. Begrenzen Sie die Anzahl der ausgewählten Eigenschaftsgruppen
2. Vermeiden Sie komplexe CSS-Verläufe für große Produktkataloge
3. Erwägen Sie die Verwendung einfacher Hex-Farben anstelle von Verläufen
4. Stellen Sie sicher, dass ordnungsgemäßes Caching aktiviert ist

## Integrationsfragen

### F: Funktioniert dies mit Produktvarianten?
**A:** Ja, das Plugin funktioniert mit Produktvarianten. Jede Variante kann ihre eigenen Farbeigenschaften haben und wird entsprechend angezeigt.

### F: Kann ich das CSS-Styling anpassen?
**A:** Ja, Sie können benutzerdefiniertes CSS hinzufügen, um das Erscheinungsbild zu ändern:
- `.topdata-color` - Hauptcontainer
- `.color` - Einzelne Farbelemente
- `.drop`, `.circle`, `.quad`, `.cursivequad`, `.own-svg` - Formspezifische Klassen

### F: Beeinflusst dies die Suchfunktionalität?
**A:** Nein, das Plugin fügt nur visuelle Elemente hinzu und ändert nicht Shopwares Suchfunktionalität.

### F: Kann ich Farben für bestimmte Produkte deaktivieren?
**A:** Weisen Sie einfach keine Farbeigenschaften zu Produkten zu, bei denen keine Farbanzeigen erscheinen sollen.

## Migration und Updates

### F: Was passiert mit meiner Konfiguration beim Update des Plugins?
**A:** Ihre Konfigurationseinstellungen bleiben bei Plugin-Updates erhalten. Sichern Sie jedoch immer Ihre Konfiguration vor dem Update.

### F: Kann ich Farbkonfigurationen exportieren/importieren?
**A:** Derzeit gibt es keine integrierte Export-/Import-Funktion. Sie können die Konfigurationswerte manuell aus den Plugin-Einstellungen kopieren.

### F: Wie migriere ich von einer älteren Version?
**A:** Folgen Sie dem Standard-Shopware-Plugin-Update-Prozess. Überprüfen Sie das Changelog auf Breaking Changes oder erforderliche Migrationsschritte.

## Support

### F: Wo kann ich zusätzlichen Support erhalten?
**A:** Kontaktieren Sie TopData Software GmbH über ihre Website unter [https://www.topdata.de](https://www.topdata.de) für technischen Support und zusätzliche Ressourcen.

### F: Wie melde ich Bugs oder fordere Features an?
**A:** Kontaktieren Sie den Plugin-Entwickler über die offiziellen Support-Kanäle von TopData Software GmbH.
