---
title: Installation
---

# Installationsanleitung

## Systemanforderungen

Bevor Sie Topdata Colors SW6 installieren, stellen Sie sicher, dass Ihr System die folgenden Anforderungen erfüllt:

- **Shopware Version**: 6.6.* oder 6.7.*
- **PHP Version**: 8.1 oder höher
- **Server-Anforderungen**: Standard Shopware 6 Server-Anforderungen

## Installationsschritte

### 1. Download und Entpacken

1. Laden Sie das Plugin-Paket von Ihrer Quelle herunter
2. Entpacken Sie die Plugin-Dateien in Ihr Shopware-Installationsverzeichnis:
   ```
   /custom/plugins/topdata-colors-sw6/
   ```

### 2. Installation über Composer (Empfohlen)

Falls Sie das Plugin über Composer verfügbar haben:

```bash
composer require topdata/topdata-colors
```

### 3. Manuelle Installation

Bei manueller Installation:

1. Kopieren Sie alle Plugin-Dateien nach `/custom/plugins/topdata-colors-sw6/`
2. Stellen Sie sicher, dass die richtigen Dateiberechtigungen gesetzt sind

### 4. Plugin-Installationsbefehle

Führen Sie die folgenden Befehle in Ihrem Shopware-Stammverzeichnis aus:

```bash
# Plugin-Liste aktualisieren
bin/console plugin:refresh

# Plugin installieren
bin/console plugin:install --activate TopdataColors

# Cache leeren
bin/console cache:clear
```

### 5. Installation überprüfen

1. Melden Sie sich in Ihrer Shopware Administration an
2. Navigieren Sie zu **Erweiterungen > Meine Erweiterungen**
3. Überprüfen Sie, dass "Topdata Colors" in der Liste der installierten Plugins erscheint
4. Prüfen Sie, dass der Plugin-Status als "Aktiv" angezeigt wird

## Einrichtung nach der Installation

Nach erfolgreicher Installation:

1. **Plugin-Einstellungen konfigurieren**: Gehen Sie zu **Erweiterungen > Meine Erweiterungen > Topdata Colors > Konfigurieren**
2. **Eigenschaftsgruppen einrichten**: Konfigurieren Sie, welche Eigenschaftsgruppen für die Farbanzeige verwendet werden sollen
3. **Anzeige testen**: Erstellen Sie ein Testprodukt mit Farbeigenschaften, um zu überprüfen, ob das Plugin korrekt funktioniert

## Fehlerbehebung bei der Installation

### Plugin nicht sichtbar
- Stellen Sie sicher, dass sich die Dateien im korrekten Verzeichnis befinden: `/custom/plugins/topdata-colors-sw6/`
- Führen Sie `bin/console plugin:refresh` aus, um die Plugin-Liste zu aktualisieren
- Überprüfen Sie die Dateiberechtigungen

### Installation schlägt fehl
- Überprüfen Sie die Shopware-Versionskompatibilität (6.6.* oder 6.7.*)
- Prüfen Sie die PHP-Versionsanforderungen
- Überprüfen Sie die Server-Fehlerprotokolle auf spezifische Fehlermeldungen
- Stellen Sie ausreichend Festplattenspeicher und Arbeitsspeicher sicher

### Cache-Probleme
- Leeren Sie alle Caches: `bin/console cache:clear`
- Falls Sie Redis oder andere Cache-Systeme verwenden, leeren Sie diese ebenfalls
- Starten Sie den Webserver bei Bedarf neu

## Deinstallation

Um das Plugin zu entfernen:

```bash
# Plugin deaktivieren
bin/console plugin:deactivate TopdataColors

# Plugin deinstallieren
bin/console plugin:uninstall TopdataColors

# Cache leeren
bin/console cache:clear
```

**Hinweis**: Die Deinstallation des Plugins entfernt standardmäßig nicht Ihre Konfigurationsdaten. Wenn Sie alle Plugin-Daten vollständig entfernen möchten, verwenden Sie das Flag `--keep-user-data=false`:

```bash
bin/console plugin:uninstall --keep-user-data=false TopdataColors
