<?php declare(strict_types=1);

namespace Topdata\TopdataColors\Component;

use Shopware\Core\System\SystemConfig\SystemConfigService;

class SettingsService
{
    /**
     * @var array
     */
    private $config;

    public function __construct(SystemConfigService $systemConfigService)
    {
        $this->config = $systemConfigService->get('TopdataColors.config');
    }
    
    public function getBool(string $key) : bool
    {
        return isset($this->config[$key]) ? (bool)$this->config[$key] : false;
    }
    
    public function getString(string $key) : string
    {
        return isset($this->config[$key]) ? (string)$this->config[$key] : '';
    }
    
    public function getInt(string $key, bool $notNegative = false) : int
    {
        $ret = isset($this->config[$key]) ? (int)$this->config[$key] : 0;
        
        if($notNegative && ($ret<0)) {
            $ret = 0;
        }
        
        return $ret;
    }
    
    public function getArray(string $key) : array
    {
        if(isset($this->config[$key])) {
            return is_array($this->config[$key]) ? $this->config[$key] : [$this->config[$key]];
        }
        
        return [];
    }
}