<?php declare(strict_types=1);

namespace Topdata\FreeTopdataColors\Subscriber;

use Shopware\Core\Content\Product\Events\ProductListingCriteriaEvent;
use Symfony\Component\EventDispatcher\EventSubscriberInterface;
use Shopware\Core\Content\Product\Events\ProductSearchCriteriaEvent;
use Shopware\Core\Framework\DataAbstractionLayer\Search\Criteria;
use Topdata\FreeTopdataColors\Component\SettingsService;
use Topdata\TopdataTopFeedSW6\Content\Product\Events\AssociatedProductsCriteriaEvent;
use Topdata\TopdataTopFinderProSW6\Content\Product\Events\DeviceProductsCriteriaEvent;
use Shopware\Core\Content\Product\Events\ProductCrossSellingIdsCriteriaEvent;
use Shopware\Core\Content\Product\Events\ProductCrossSellingStreamCriteriaEvent;

class ProductListingSubscriber implements EventSubscriberInterface
{
    protected SettingsService $settingsService;

    public function __construct(
        SettingsService $settingsService
    )
    {
        $this->settingsService = $settingsService;
    }


    public static function getSubscribedEvents(): array
    {
        return [
            ProductListingCriteriaEvent::class            => 'handleProductListingCriteria',
            ProductSearchCriteriaEvent::class             => 'handleSearchProductListingCriteria',
            AssociatedProductsCriteriaEvent::class        => 'handleAssociatedProductsListingCriteria',
            DeviceProductsCriteriaEvent::class            => 'handleDeviceProductsCriteria',
            ProductCrossSellingIdsCriteriaEvent::class    => 'handleProductCrossSellingIdsCriteria',
            ProductCrossSellingStreamCriteriaEvent::class => 'handleProductCrossSellingStreamCriteria',
        ];
    }


    private function addCriteriaAssociation(Criteria $criteria): void
    {
        $propertyGroupIds = $this->settingsService->getArray('colorPropertyGroups');
        if ($propertyGroupIds) {
            $criteria->addAssociation('properties.group');
        }
    }


    public function handleProductListingCriteria(ProductListingCriteriaEvent $event): void
    {
        $this->addCriteriaAssociation($event->getCriteria());
    }

    public function handleSearchProductListingCriteria(ProductListingCriteriaEvent $event): void
    {
        $this->addCriteriaAssociation($event->getCriteria());
    }


    public function handleAssociatedProductsListingCriteria(AssociatedProductsCriteriaEvent $event): void
    {
        $this->addCriteriaAssociation($event->getCriteria());
    }


    public function handleDeviceProductsCriteria(DeviceProductsCriteriaEvent $event): void
    {
        $this->addCriteriaAssociation($event->getCriteria());
    }


    public function handleProductCrossSellingIdsCriteria(ProductCrossSellingIdsCriteriaEvent $event): void
    {
        $this->addCriteriaAssociation($event->getCriteria());
    }


    public function handleProductCrossSellingStreamCriteria(ProductCrossSellingStreamCriteriaEvent $event): void
    {
        $this->addCriteriaAssociation($event->getCriteria());
    }
}