---
title: Usage Guide
---

# Usage Guide

This guide explains how to set up and use the color display functionality in your Shopware store.

## Setting Up Product Properties

### Step 1: Create Property Groups

1. Navigate to **Catalogues > Properties** in your Shopware Administration
2. Click **Add property group**
3. Enter a name for your color property group (e.g., "Product Colors", "Main Color", "Accent Color")
4. Configure the group settings:
   - **Display type**: Choose how properties should be displayed in filters
   - **Sorting type**: Set how color options should be sorted
   - **Filterable**: Enable if you want customers to filter by colors

### Step 2: Add Color Properties

1. Open your newly created property group
2. Click **Add property** to add individual color options
3. For each color property:
   - **Name**: Enter the color name (e.g., "Red", "Blue", "Forest Green")
   - **Color hex code**: Optionally set a specific hex code (this overrides the plugin's built-in colors)
   - **Position**: Set the display order
   - **Media**: Optionally add a color swatch image

### Step 3: Configure Plugin Settings

1. Go to **Extensions > My Extensions > Topdata Colors > Configure**
2. In the **Color Property Groups** field, select the property groups you created
3. Configure other settings as needed (see Configuration Settings guide)
4. Save the configuration

### Step 4: Assign Properties to Products

1. Edit a product in **Catalogues > Products**
2. Go to the **Properties** tab
3. Select the appropriate color properties for this product
4. Save the product

## Understanding Color Display Logic

### Color Mapping Priority

The plugin determines the color for a property based on a clear order of priority. As soon as a matching color is found, the subsequent steps are ignored:

1.  **Custom Color Overrides (Highest Priority)**
    - First, the plugin checks if the property name is defined in the "Color Overrides" field within the plugin configuration.
    - **Example**: If you define `red|#FF00FF`, the property "Red" will always be displayed as pink, regardless of any other settings.

2.  **Property Hex Code**
    - If no custom override is found, the plugin checks if a "Color hex code" has been set for the property itself in the Shopware Administration (under **Catalogues > Properties**).
    - **Example**: If the "Red" property has the hex code `#FFC0CB`, this value will be used.

3.  **Built-in Color Database (Lowest Priority)**
    - If neither of the above conditions are met, the plugin searches for the property name in its built-in database of over 200 predefined colors.
    - **Example**: If the property is named "Red" and has not been overridden, the default value `#ff0000` will be used.

### Color Name Matching

Color names are matched case-insensitively. These all work the same:
- "Red" → matches built-in red color
- "red" → matches built-in red color  
- "RED" → matches built-in red color

### Multi-Color Syntax

The plugin supports advanced color combinations:

#### Count Prefixes
- `3x red` → Displays 3 red dots
- `2x blue` → Displays 2 blue dots

#### Color Combinations
- `red+blue` → Displays red and blue dots together (primary separator)
- `red/blue` → Legacy separator (still supported for backward compatibility)
- `red+blue+green` → Displays three colors together

#### Complex Examples
- `2x red+blue` → Displays 2 combination dots (each with red and blue)
- `3x multicolor` → Displays 3 multicolor dots
- `red, blue, green` → Displays separate color groups (comma-separated)

## Product Setup Examples

### Example 1: Simple Single Color Product

**Product**: Red T-Shirt
**Property Assignment**: "Red" from "Product Colors" group
**Result**: Single red dot displayed

### Example 2: Multi-Color Product

**Product**: Striped Shirt
**Property Assignment**: "Red+Blue" from "Product Colors" group
**Result**: Red and blue dots displayed together

### Example 3: Product with Multiple Color Options

**Product**: Available in multiple colors
**Property Assignment**: "Red", "Blue", "Green" from "Product Colors" group
**Result**: Three separate color dots displayed

### Example 4: Product with Color Variations

**Product**: Jacket with accent colors
**Property Assignment**: 
- "Black" from "Main Color" group
- "Red" from "Accent Color" group
**Result**: Black dot and red dot displayed

## Best Practices

### Property Naming

1. **Use standard color names** when possible (red, blue, green, etc.)
2. **Be consistent** across your product catalog
3. **Use descriptive names** for custom colors (e.g., "Forest Green" instead of "Green1")
4. **Consider translations** if you operate in multiple languages

### Property Group Organization

1. **Create specific groups** for different color types:
   - "Main Color" for primary product colors
   - "Accent Color" for secondary colors
   - "Pattern Colors" for multi-colored patterns

2. **Keep groups focused** - don't mix color properties with other attributes
3. **Use clear naming** that makes sense to your team

### Color Override Strategy

1. **Start with built-in colors** before adding custom overrides
2. **Document custom colors** for your team
3. **Use hex codes consistently** (#ff0000 format)
4. **Test color combinations** before going live

## Display Locations

Colors automatically appear in:

### Product Listing Pages
- Category pages
- Search results
- Brand pages
- Tag pages

### Product Detail Pages
- Main product information area
- Variant selection (if applicable)

### Cross-Selling Areas
- Related products
- Recommended products
- Recently viewed products

### Comparison Features
- Product comparison popups
- Wishlist displays

## Troubleshooting Common Issues

### Colors Not Appearing

1. **Check property group selection** in plugin configuration
2. **Verify property assignment** to products
3. **Clear cache** after configuration changes
4. **Check color name spelling** against built-in database

### Wrong Colors Displaying

1. **Verify property names** match color database entries
2. **Check custom color overrides** for conflicts
3. **Review property hex codes** in property configuration
4. **Test with simple color names** first

### Performance Optimization

1. **Limit property groups** to only those needed for colors
2. **Use simple color names** instead of complex overrides when possible
3. **Avoid excessive custom SVG complexity**
4. **Monitor page load times** with many color properties

## Advanced Usage

### Custom Color Definitions

For colors not in the built-in database, add them to the color overrides:

```
corporate-blue|#1e3a8a
brand-red|#dc2626
custom-green|#059669
```

### Pattern and Gradient Colors

Create special visual effects:

```
rainbow|linear-gradient(45deg, #ff0000, #00ff00, #0000ff)
stripes|repeating-linear-gradient(45deg, #000, #000 2px, #fff 2px, #fff 4px)
```

### Multi-Language Support

Define color names in multiple languages:

```
rot|#ff0000
rouge|#ff0000
rojo|#ff0000
```

## Integration with Themes

The plugin works with most Shopware themes. If you need to customize the appearance:

1. **Override templates** in your theme if needed
2. **Add custom CSS** to style color displays
3. **Use provided CSS classes** for styling:
   - `.topdata-color` - Main container
   - `.color` - Individual color elements
   - `.group` - Color group container

## Testing Your Setup

1. **Create test products** with various color combinations
2. **Check different page types** (listing, detail, search)
3. **Test with different devices** and screen sizes
4. **Verify color accuracy** matches your expectations
5. **Test performance** with realistic product catalogs

By following this guide, you should be able to successfully implement and use the color display functionality throughout your Shopware store.
