---
title: Installation
---

# Installation Guide

## System Requirements

Before installing Topdata Colors SW6, ensure your system meets the following requirements:

- **Shopware Version**: 6.6.* or 6.7.*
- **PHP Version**: 8.1 or higher
- **Server Requirements**: Standard Shopware 6 server requirements

## Installation Steps

### 1. Download and Extract

1. Download the plugin package from your source
2. Extract the plugin files to your Shopware installation directory:
   ```
   /custom/plugins/topdata-colors-sw6/
   ```

### 2. Install via Composer (Recommended)

If you have the plugin available via Composer:

```bash
composer require topdata/topdata-colors
```

### 3. Manual Installation

If installing manually:

1. Copy all plugin files to `/custom/plugins/topdata-colors-sw6/`
2. Ensure proper file permissions are set

### 4. Plugin Installation Commands

Execute the following commands in your Shopware root directory:

```bash
# Refresh plugin list
bin/console plugin:refresh

# Install the plugin
bin/console plugin:install --activate FreeTopdataColors

# Clear cache
bin/console cache:clear
```

### 5. Verify Installation

1. Log into your Shopware Administration
2. Navigate to **Extensions > My Extensions**
3. Verify that "Topdata Colors" appears in the installed plugins list
4. Check that the plugin status shows as "Active"

## Post-Installation Setup

After successful installation:

1. **Configure Plugin Settings**: Go to **Extensions > My Extensions > Topdata Colors > Configure**
2. **Set Up Property Groups**: Configure which property groups should be used for color display
3. **Test Display**: Create a test product with color properties to verify the plugin works correctly

## Troubleshooting Installation

### Plugin Not Visible
- Ensure files are in the correct directory: `/custom/plugins/topdata-colors-sw6/`
- Run `bin/console plugin:refresh` to update the plugin list
- Check file permissions

### Installation Fails
- Verify Shopware version compatibility (6.6.* or 6.7.*)
- Check PHP version requirements
- Review server error logs for specific error messages
- Ensure sufficient disk space and memory

### Cache Issues
- Clear all caches: `bin/console cache:clear`
- If using Redis or other cache systems, clear those as well
- Restart web server if necessary

## Uninstallation

To remove the plugin:

```bash
# Deactivate the plugin
bin/console plugin:deactivate FreeTopdataColors

# Uninstall the plugin
bin/console plugin:uninstall FreeTopdataColors

# Clear cache
bin/console cache:clear
```

**Note**: Uninstalling the plugin will not remove your configuration data by default. If you want to completely remove all plugin data, use the `--keep-user-data=false` flag:

```bash
bin/console plugin:uninstall --keep-user-data=false FreeTopdataColors
