import Plugin from 'src/plugin-system/plugin.class';

export default class TdxFilterStatePlugin extends Plugin {
    static options = {
        initialFilterState: 'collapsed'
    };

    init() {
        this._applyInitialFilterState();
    }

    _applyInitialFilterState() {
        const state = this.options.initialFilterState;

        if (state === 'expanded') {
            this._expandAllFilterAccordions();
        }
        // If state is 'collapsed', do nothing (default Bootstrap behavior)
    }

    _expandAllFilterAccordions() {
        // Find all filter panel toggle buttons
        const toggleButtons = document.querySelectorAll('.filter-panel-item-toggle[data-bs-toggle="collapse"]');

        toggleButtons.forEach(button => {
            const targetId = button.getAttribute('data-bs-target');
            if (targetId) {
                const targetElement = document.querySelector(targetId);
                if (targetElement) {
                    // Add 'show' class to make the collapse visible
                    targetElement.classList.add('show');
                    // Set aria-expanded to true
                    button.setAttribute('aria-expanded', 'true');
                }
            }
        });
    }
}