# Topdata Category Filter SW6 Einstellungsleitfaden

Dieser Leitfaden bietet detaillierte Informationen zu allen Konfigurationsoptionen, die im Topdata Category Filter SW6 Plugin verfügbar sind.

## Allgemeine Einstellungen

### Kategoriefilterkonfiguration

| Einstellung | Standard | Beschreibung |
|-------------|----------|--------------|
| `showCategoryFilter` | true | Aktiviert oder deaktiviert den Kategoriefilter im Storefront. |
| `showNumber` | true | Zeigt die Anzahl der Produkte in jeder Kategorie an. |
| `collapseSubcategories` | true | Blendet Unterkategorien im Filter zunächst ein. Benutzer können sie erweitern. |
| `showFirst` | true | Zeigt den Kategoriefilter als ersten Filter im Panel an. |
| `hideOtherBranches` | true | Blendet Kategorien aus anderen Kategoriezweigen auf Kategorieseiten aus. |
| `excludeHidden` | false | Blendet Kategorien aus, die als "In Navigation ausblenden" markiert sind. |
| `hideSingleCategory` | true | Blendet den Filter aus, wenn nur eine Kategorie verfügbar ist. |
| `hideDynamicCategory` | true | Blendet Kategorien mit dynamischen Produktgruppen aus. |
| `popularCount` | 0 | Zeigt nur Kategorien mit einer Mindestanzahl von Produkten an. Setzen Sie auf 0, um alle anzuzeigen. |
| `hideParents` | false | Blendet übergeordnete Kategorien im Filter aus. |
| `sort` | none | Legt die Sortierreihenfolge der Kategorien fest (Name, Anzahl oder Standard). |

## Ansichtsoptionen

### Kategoriefilter-Ansichtsoptionen

| Einstellung | Standard | Beschreibung |
|-------------|----------|--------------|
| `manyMainCategories` | true | Behandelt Fälle, in denen es nur eine Hauptkategorie gibt, indem sie in Unterkategorien aufgeteilt wird. |
| `joinParents` | false | Kombiniert übergeordnete Kategorien in der Anzeige. Kategorienamen werden durch "/" getrennt. |
| `showParentCategory` | 0 | Gibt an, wie viele Ebenen übergeordneter Kategorien angezeigt werden sollen (0 bis 20 oder "Alle"). |

## Leistungseinstellungen

### Optimierungsoptionen

| Einstellung | Standard | Beschreibung |
|-------------|----------|--------------|
| `hideUnpopular` | false | Entfernt Kategorien mit geringer Produktanzahl, um die Leistung zu verbessern. |
| `joinParents` | true | Vereinigt Elternkategorien mit nur einem Kind, um den Kategoriebbaum zu vereinfachen. |
| `showParentCategory` | 2 | Begrenzt die Anzahl der angezeigten Elternstufen in Kategorienamen für eine bessere Lesbarkeit. |

## Empfohlene Konfigurationen

- Für Geschäfte mit einer tiefen Kategorienstruktur sollten Sie `hideUnpopular` aktivieren, um die Leistung zu verbessern.
- Wenn Sie nur eine Hauptkategorie haben, aktivieren Sie `manyMainCategories` für eine bessere Visualisierung.
- Für Geschäfte mit dynamischen Produktgruppen möchten Sie möglicherweise `hideDynamicCategory` deaktivieren.

## Visuelle Beispiele

### Standardansicht

![Standard Kategoriefilter](https://example.com/default-filter.png)

### Eingeklappte Unterkategorien

![Eingeklappter Filter](https://example.com/collapsed-filter.png)

### Kombinierte Elternkategorien

![Vereinigte Eltern](https://example.com/joined-parents.png)