# Topdata Category Filter SW6 Settings Guide

This guide provides detailed information about all the configuration options available in the Topdata Category Filter SW6 plugin.

## General Settings

### Category Filter Configuration

| Setting | Default | Description |
|---------|---------|-------------|
| `showCategoryFilter` | true | Enables or disables the category filter in the storefront. |
| `showNumber` | true | Displays the number of products in each category. |
| `collapseSubcategories` | true | Initially collapses subcategories in the filter. Users can expand them. |
| `showFirst` | true | Displays the category filter as the first filter in the panel. |
| `hideOtherBranches` | true | Hides categories from other category branches on category pages. |
| `excludeHidden` | false | Hides categories marked as "Hide in navigation". |
| `hideSingleCategory` | true | Hides the filter if there's only one category available. |
| `hideDynamicCategory` | true | Hides categories with dynamic product groups. |
| `popularCount` | 0 | Shows only categories with a minimum number of products. Set to 0 to show all. |
| `hideParents` | false | Hides parent categories in the filter. |
| `sort` | none | Determines the sorting order of categories (name, count, or default). |

## View Options

### Category Filter View Options

| Setting | Default | Description |
|---------|---------|-------------|
| `manyMainCategories` | true | Handles cases where there's only one main category by dividing it into subcategories. |
| `joinParents` | false | Combines parent categories in the display. Category names are separated by "/". |
| `showParentCategory` | 0 | Specifies how many parent category levels to show (0 to 20, or "All"). |

## Performance Settings

### Optimization Options

| Setting | Default | Description |
|---------|---------|-------------|
| `hideUnpopular` | false | Removes categories with low product counts to improve performance. |
| `joinParents` | true | Merges single-child parent categories to simplify the category tree. |
| `showParentCategory` | 2 | Limits the number of parent levels shown in category names for better readability. |

## Recommended Configurations

- For stores with a deep category structure, consider enabling `hideUnpopular` to improve performance.
- If you have a single main category, enable `manyMainCategories` for better visualization.
- For stores with dynamic product groups, you may want to disable `hideDynamicCategory`.

## Visual Examples

### Default View

![Default Category Filter](https://example.com/default-filter.png)

### Collapsed Subcategories

![Collapsed Filter](https://example.com/collapsed-filter.png)

### Combined Parent Categories

![Joined Parents](https://example.com/joined-parents.png)