# Topdata Category Filter SW6 FAQ & Fehlerbehebung

## Häufige Probleme

| Symptom | Wahrscheinliche Ursache | Lösung |
|---------|-------------------------|--------|
| Fehlende Kategorien | Ausgeblendete Kategorien | Überprüfen Sie die Einstellung `excludeHidden` in der Plugin-Konfiguration. |
| Langsame Filterladezeit | Komplexe Baumverarbeitung | Aktivieren Sie die Option `hideUnpopular`, um Kategorien mit geringer Produktanzahl zu entfernen. |
| Dynamische Kategorien fehlen | Mapping-Problem | Stellen Sie sicher, dass die Eigenschaft `streamCategories` korrekt in Ihrem Elasticsearch-Index konfiguriert ist. |
| URL-Parameter funktionieren nicht | Verarbeitung von Anforderungsparametern | Überprüfen Sie die Methode `_getCategoryIdsFromRequest` in der Subscriber-Klasse. |

## Fehlerbehebungsleitfaden

### 1. Fehlende Kategorien im Filter

Wenn Sie feststellen, dass einige Kategorien im Filter nicht angezeigt werden:

1. Überprüfen Sie, ob die Einstellung `excludeHidden` aktiviert ist, die Kategorien ausblendet, die als "In Navigation ausblenden" markiert sind.
2. Stellen Sie sicher, dass den Kategorien Produkte zugewiesen sind.
3. Überprüfen Sie, ob der Elasticsearch-Index mit den neuesten Kategoriedaten aktualisiert ist.

### 2. Langsame Filterleistung

Wenn der Kategoriefilter langsam lädt:

1. Aktivieren Sie die Einstellung `hideUnpopular`, um Kategorien mit geringer Produktanzahl zu entfernen.
2. Erhöhen Sie ggf. den `popularCount`-Schwellenwert, um nur die beliebtesten Kategorien anzuzeigen.
3. Aktivieren Sie das Caching für die Kategorienbaumdaten.

### 3. Dynamische Kategorien werden nicht angezeigt

Wenn dynamische Produktgruppen im Filter nicht angezeigt werden:

1. Stellen Sie sicher, dass die Einstellung `hideDynamicCategory` deaktiviert ist.
2. Überprüfen Sie, ob die Elasticsearch-Mapping die Eigenschaft `streamCategories` enthält.
3. Stellen Sie sicher, dass Produkte korrekt dynamischen Kategorien zugewiesen sind.

### 4. URL-Parameter funktionieren nicht

Wenn Kategorienauswahlen in der URL nicht gespeichert werden:

1. Überprüfen Sie die Methode `_getCategoryIdsFromRequest` in der Subscriber-Klasse.
2. Stellen Sie sicher, dass der Filtername (`tdxcats`) korrekt in den Plugin-Einstellungen konfiguriert ist.
3. Überprüfen Sie, ob JavaScript-Fehler die Filteraktualisierung der URL verhindern.

## Best Practices

### Kategorienverwaltung

- Überprüfen und aktualisieren Sie regelmäßig Ihre Kategorienstruktur, um sicherzustellen, dass sie optimiert bleibt.
- Verwenden Sie beschreibende Kategoriennamen, um den Kunden die Produktgruppen zu erläutern.
- Berücksichtigen Sie die Tiefe Ihres Kategorienbaums und aktivieren Sie Einstellungen wie `hideUnpopular` für eine bessere Leistung.

### Leistungsoptimierung

- Aktivieren Sie das Caching für den Kategorienbaum, um die Verarbeitungszeit zu reduzieren.
- Verwenden Sie die Einstellung `popularCount`, um die Anzahl der angezeigten Kategorien zu begrenzen.
- Überlegen Sie, Kategorien-ID-Abfragen in Ihren Elasticsearch-Abfragen zu bündeln.

### Konfigurationstipps

- Für Geschäfte mit einer komplexen Kategorienstruktur aktivieren Sie `joinParents`, um die Anzeige zu vereinfachen.
- Verwenden Sie die Einstellung `showParentCategory`, um zu steuern, wie viele Elternstufen in Kategorienamen angezeigt werden.
- Überprüfen und aktualisieren Sie regelmäßig Ihre Konfigurationseinstellungen, um den Bedürfnissen Ihres Geschäfts gerecht zu werden.