# Topdata Category Filter SW6 Installation Guide

## System Requirements

- Shopware 6.4.x or higher
- PHP 8.0 or higher
- Composer installed on your server

## Installation Steps

### 1. Install via Composer

Open your terminal and navigate to your Shopware project directory. Run the following command to install the plugin:

```bash
composer require topdata/topdata-category-filter-sw6
```

### 2. Activate the Plugin

After the installation is complete, you need to activate the plugin. You can do this via the Shopware admin panel or using the command line.

#### Option A: Using the Shopware Admin Panel

1. Log in to your Shopware admin panel
2. Go to **Extensions** > **My extensions**
3. Find "Topdata Category Filter SW6" in the list
4. Click **Activate**

#### Option B: Using the Command Line

Run the following command in your Shopware project directory:

```bash
bin/console plugin:install --activate FreeTopdataCategoryFilterSW6
```

### 3. Clear Cache

After activating the plugin, it's recommended to clear your cache to ensure all changes take effect:

```bash
bin/console cache:clear
```

## Verification

To verify that the plugin has been installed and activated correctly:

1. Go to the product listing page in your storefront
2. You should see the category filter in the filter panel
3. Test the filter functionality by selecting different categories

## Troubleshooting

If you encounter any issues during installation:

- Check the Shopware error logs for detailed error messages
- Ensure that your server meets all the system requirements
- Verify that Composer has the necessary permissions to install plugins