import DomAccess from 'src/helper/dom-access.helper';
import FilterBasePlugin from 'src/plugin/listing/filter-base.plugin';
import FilterMultiSelectPlugin from "src/plugin/listing/filter-multi-select.plugin";
import Iterator from 'src/helper/iterator.helper';
import deepmerge from 'deepmerge';


const FILTER_NAME = 'tdxcats'; // former options.name
const SELECTOR_CHECKBOX = '._selector_topdata-category-filter__item-checkbox'; // former options.checkboxSelector
const SELECTOR_COLLAPSER = '._selector_topdata-category-filter__fixed-collapser';
const SELECTOR_COUNT_CHOSEN_CATS = '._selector_topdata-category-filter__count-chosen-cats'; // former options.countSelector
// const SELECTOR_LIST_ITEM = '.tdx-filter-multi-select-list-item'; // former options.listItemSelector
// const SELECTOR_MAIN_FILTER_BUTTON = '.tdx-filter-panel-item-toggle'; // former options.mainFilterButtonSelector

export default class TdxFilterMultiSelectTreePlugin extends FilterBasePlugin {


    // overwrite
    static options = deepmerge(FilterBasePlugin.options, {
        // checkboxSelector: SELECTOR_CHECKBOX,
        // countSelector: SELECTOR__COUNT_CHOSEN_CATS,
        // listItemSelector: SELECTOR_LIST_ITEM, // unused
        // snippets: {
        //     disabledFilterText: 'Filter not active',
        // },
        name: FILTER_NAME, // needed
    });




    // overwrite
    init() {
        console.log("Mi 5. Jun 08:59:06 UTC 2024");
        // console.log("===== TEST =====")
        this.selection = [];

        this._registerEvents();
    }

    _registerEvents() {
        // ---- checkboxes
        const checkboxes = DomAccess.querySelectorAll(this.el, SELECTOR_CHECKBOX);
        checkboxes.forEach((checkbox) => {
            checkbox.addEventListener('change', this._onChangeFilter.bind(this));
        });

        // ---- collapsers
        const collapsers = this.el.querySelectorAll(SELECTOR_COLLAPSER);
        collapsers.forEach((element) => {
            element.addEventListener('click', this._onClickCollapser.bind(this));
        });
    }

    _onClickCollapser(event) {
        let target = this.el.querySelector(event.currentTarget.dataset.target)

        if (target) {
            event.currentTarget.classList.toggle('fixed-expanded');
            target.classList.toggle('show');
        }
    }



    _updateCount() {
        const cnt = this.selection.length;
        DomAccess.querySelector(this.el, SELECTOR_COUNT_CHOSEN_CATS).innerText = cnt ? `(${cnt})` : '';
    }


    getValues() {
        const checkedCheckboxes = DomAccess.querySelectorAll(this.el, `${SELECTOR_CHECKBOX}:checked`, false);

        let selection = [];

        if (checkedCheckboxes) {
            Iterator.iterate(checkedCheckboxes, (checkbox) => {
                selection.push(checkbox.id);
            });
        } else {
            selection = [];
        }

        this.selection = selection;
        this._updateCount();

        // const values = {};
        // values[FILTER_NAME] = selection;
        // console.log("==== TdxFilterMultiSelectTreePlugin.getValues", {FILTER_NAME: selection});
        // return values;
        return {[FILTER_NAME]: selection};
    }


    getLabels() {
        const activeCheckboxes =
            DomAccess.querySelectorAll(this.el, `${SELECTOR_CHECKBOX}:checked`, false);

        let labels = [];

        if (activeCheckboxes) {
            Iterator.iterate(activeCheckboxes, (checkbox) => {
                labels.push({
                    label: checkbox.dataset.label,
                    id: checkbox.id,
                });
            });
        } else {
            labels = [];
        }

        return labels;
    }


    setValuesFromUrl(params = {}) {
        let stateChanged = false;

        const properties = params[FILTER_NAME];

        const ids = properties ? properties.split('|') : [];

        const uncheckItems = this.selection.filter(x => !ids.includes(x));
        const checkItems = ids.filter(x => !this.selection.includes(x));

        if (uncheckItems.length > 0 || checkItems.length > 0) {
            stateChanged = true;
        }

        checkItems.forEach(id => {
            const checkboxEl = DomAccess.querySelector(this.el, `[id="${id}"]`, false);

            if (checkboxEl) {
                checkboxEl.checked = true;
                this.selection.push(checkboxEl.id);
            }
        });

        uncheckItems.forEach(id => {
            this.reset(id);

            this.selection = this.selection.filter(item => item !== id);
        });

        this._updateCount();

        return stateChanged;
    }

    _onChangeFilter() {
        // reset page to 1 when updating the filter
        this.listing.changeListing(true, { p: 1 });
    }

    /**
     * @param id
     * @public
     */
    reset(id) {
        const checkboxEl = DomAccess.querySelector(this.el, `[id="${id}"]`, false);

        if (checkboxEl) {
            checkboxEl.checked = false;
        }
    }


    /**
     * @public
     */
    resetAll() {
        this.selection.filter = [];

        const checkedCheckboxes =
            DomAccess.querySelectorAll(this.el, `${SELECTOR_CHECKBOX}:checked`, false);

        if (checkedCheckboxes) {
            Iterator.iterate(checkedCheckboxes, (checkbox) => {
                checkbox.checked = false;
            });
        }
    }


    // disableFilter() {
    //     const mainFilterButton = DomAccess.querySelector(this.el, SELECTOR_MAIN_FILTER_BUTTON);
    //     mainFilterButton.classList.add('disabled');
    //     mainFilterButton.setAttribute('disabled', 'disabled');
    //     mainFilterButton.setAttribute('title', this.options.snippets.disabledFilterText);
    // }

    // enableFilter() {
    //     const mainFilterButton = DomAccess.querySelector(this.el, SELECTOR_MAIN_FILTER_BUTTON);
    //     mainFilterButton.classList.remove('disabled');
    //     mainFilterButton.removeAttribute('disabled');
    //     mainFilterButton.removeAttribute('title');
    // }


    // refreshDisabledState(filter) {
    //     const disabledFilter = filter[FILTER_NAME];
    //     if(!disabledFilter) {
    //         // it crashed if 'tdxcats' === 'categories' instead of 'category'
    //         console.error(`No filter "${FILTER_NAME}" found, possible keys: ${Object.keys(filter)}`);
    //         return;
    //     } else {
    //         console.log("disabledFilter", disabledFilter);
    //     }
    //     if (!disabledFilter.entities || disabledFilter.entities.length < 1) {
    //         // this.disableFilter();
    //         return;
    //     }
    //
    //     this.enableFilter();
    //
    //     this._disableInactiveFilterOptions(disabledFilter.entities.map(entity => entity.id));
    // }

    // _disableInactiveFilterOptions(activeItemIds) {
    //     const checkboxes = DomAccess.querySelectorAll(this.el, SELECTOR_CHECKBOX);
    //     Iterator.iterate(checkboxes, (checkbox) => {
    //         if (checkbox.checked === true) {
    //             return;
    //         }
    //
    //         if (activeItemIds.includes(checkbox.id)) {
    //             this.enableOption(checkbox);
    //         } else {
    //             this.disableOption(checkbox);
    //         }
    //     });
    // }


    // disableOption(input){
    //     const listItem = input.closest(SELECTOR_LIST_ITEM);
    //     listItem.classList.add('disabled');
    //     listItem.setAttribute('title', this.options.snippets.disabledFilterText);
    //     input.disabled = true;
    // }

    // enableOption(input) {
    //     const listItem = input.closest(SELECTOR_LIST_ITEM);
    //     listItem.removeAttribute('title');
    //     listItem.classList.remove('disabled');
    //     input.disabled = false;
    // }


}
