<?php declare(strict_types=1);

namespace Topdata\FreeTopdataCategoryFilterSW6\Content\Product;

use Shopware\Core\Content\Product\ProductDefinition;
use Shopware\Core\Framework\DataAbstractionLayer\EntityExtension;
use Shopware\Core\Framework\DataAbstractionLayer\Field\ObjectField;
use Shopware\Core\Framework\DataAbstractionLayer\Field\OneToManyAssociationField;
use Shopware\Core\Framework\DataAbstractionLayer\Field\ManyToManyAssociationField;
use Shopware\Core\Framework\DataAbstractionLayer\FieldCollection;
use Shopware\Core\Content\Category\CategoryDefinition;
use Shopware\Core\Content\Product\Aggregate\ProductStreamMapping\ProductStreamMappingDefinition;
use Shopware\Core\Framework\DataAbstractionLayer\Field\Flag\ApiAware;

class ProductExtension extends EntityExtension
{
    public function extendFields(FieldCollection $collection): void
    {
        $collection->add(
            (new ManyToManyAssociationField(
                'streamCategories', 
                CategoryDefinition::class, 
                ProductStreamMappingDefinition::class, 
                'product_id', 
                'product_stream_id',
                'id',
                'product_stream_id'
            ))->addFlags(new ApiAware())
        );
    }

    // sw6.6
    public function getDefinitionClass(): string
    {
        return ProductDefinition::class;
    }

    // sw6.7
    public function getEntityName(): string
    {
        return ProductDefinition::ENTITY_NAME;
    }
}