# Topdata Category Filter SW6 FAQ & Troubleshooting

## Common Issues

| Symptom | Likely Cause | Solution |
|---------|--------------|----------|
| Missing categories | Hidden category exclusion | Check the `excludeHidden` setting in the plugin configuration. |
| Slow filter loading | Complex tree processing | Enable the `hideUnpopular` option to remove low-count categories. |
| Dynamic categories missing | Mapping issue | Verify that the `streamCategories` property is correctly configured in your Elasticsearch index. |
| URL parameters not working | Request parameter handling | Check the `_getCategoryIdsFromRequest` method in the Subscriber class. |

## Troubleshooting Guide

### 1. Missing Categories in Filter

If you notice that some categories are not appearing in the filter:

1. Check if the `excludeHidden` setting is enabled, which hides categories marked as "Hide in navigation".
2. Verify that the categories have products assigned to them.
3. Ensure that the Elasticsearch index is up-to-date with the latest category data.

### 2. Slow Filter Performance

If the category filter is loading slowly:

1. Enable the `hideUnpopular` setting to remove categories with low product counts.
2. Consider increasing the `popularCount` threshold to show only the most popular categories.
3. Enable caching for the category tree data.

### 3. Dynamic Categories Not Displayed

If dynamic product groups are not appearing in the filter:

1. Verify that the `hideDynamicCategory` setting is disabled.
2. Check that the Elasticsearch mapping includes the `streamCategories` property.
3. Ensure that products are properly assigned to dynamic categories.

### 4. URL Parameters Not Working

If category selections are not being preserved in the URL:

1. Check the `_getCategoryIdsFromRequest` method in the Subscriber class.
2. Ensure that the filter name (`tdxcats`) is correctly configured in the plugin settings.
3. Verify that JavaScript errors are not preventing the filter from updating the URL.

## Best Practices

### Category Management

- Regularly review and update your category structure to ensure it remains optimized.
- Use descriptive category names to help customers understand the product groupings.
- Consider the depth of your category tree and enable settings like `hideUnpopular` for better performance.

### Performance Optimization

- Enable caching for the category tree to reduce processing time.
- Use the `popularCount` setting to limit the number of categories displayed.
- Consider batching category ID lookups in your Elasticsearch queries.

### Configuration Tips

- For stores with a complex category structure, enable `joinParents` to simplify the display.
- Use the `showParentCategory` setting to control how many parent levels are shown in category names.
- Regularly review and update your configuration settings to match your store's needs.