<?php

declare(strict_types=1);

namespace Sisi\Search\ServicesInterfaces;

use Shopware\Core\Checkout\Cart\Price\QuantityPriceCalculator;
use Shopware\Core\Checkout\Cart\Price\Struct\CartPrice;
use Shopware\Core\Checkout\Cart\Price\Struct\PriceCollection as CalculatedPriceCollection;
use Shopware\Core\Checkout\Cart\Price\Struct\QuantityPriceDefinition;
use Shopware\Core\Checkout\Cart\Price\Struct\ReferencePriceDefinition;
use Shopware\Core\Content\Product\Aggregate\ProductPrice\ProductPriceCollection;
use Shopware\Core\Content\Product\DataAbstractionLayer\CheapestPrice\CalculatedCheapestPrice;
use Shopware\Core\Content\Product\DataAbstractionLayer\CheapestPrice\CheapestPrice;
use Shopware\Core\Content\Product\SalesChannel\Price\ReferencePriceDto;
use Shopware\Core\Content\Product\SalesChannel\SalesChannelProductEntity;
use Shopware\Core\Framework\DataAbstractionLayer\Entity;
use Shopware\Core\Framework\DataAbstractionLayer\EntityRepositoryInterface;
use Shopware\Core\Framework\DataAbstractionLayer\Pricing\Price;
use Shopware\Core\Framework\DataAbstractionLayer\Pricing\PriceCollection;
use Shopware\Core\Framework\DataAbstractionLayer\Search\Criteria;
use Shopware\Core\Framework\Plugin\Exception\DecorationPatternException;
use Shopware\Core\System\SalesChannel\SalesChannelContext;
use Shopware\Core\System\Unit\UnitCollection;
use Symfony\Contracts\Service\ResetInterface;

/**
 * Interface InterfaceSisiProductPriceCalculator
 *
 * This interface defines the methods for calculating product prices, advance prices, and cheapest prices within the Sisi Search context.
 * It also provides a method for retrieving unit collections.
 * @SuppressWarnings(PHPMD.StaticAccess)
 * @SuppressWarnings(PHPMD.CouplingBetweenObjects)
 */
interface InterfaceSisiProductPriceCalculator
{
    /**
     * Calculates the price of a product.
     *
     * @param Entity $product The product entity.
     * @param SalesChannelContext $context The sales channel context.
     * @param UnitCollection $units The unit collection.
     */
    public function calculatePrice(Entity &$product, SalesChannelContext $context, UnitCollection $units): void;

    /**
     * Calculates the advance prices of a product.
     *
     * @param Entity $product The product entity.
     * @param SalesChannelContext $context The sales channel context.
     * @param UnitCollection $units The unit collection.
     */
    public function calculateAdvancePrices(Entity &$product, SalesChannelContext $context, UnitCollection $units): void;

    /**
     * Calculates the cheapest price of a product.
     *
     * @param Entity $product The product entity.
     * @param SalesChannelContext $context The sales channel context.
     * @param UnitCollection $units The unit collection.
     */
    public function calculateCheapestPrice(&$product, $context, $units);

    /**
     * Retrieves the unit collection.
     *
     * @param SalesChannelContext $context The sales channel context.
     * @return UnitCollection
     */
    public function getUnits(SalesChannelContext $context): UnitCollection;
}